package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class ShippingInfoImportDraft {
  private String shippingMethodName;

  private MoneyInput price;

  private ShippingRateDraft shippingRate;

  private TaxRateInput taxRate;

  private ResourceIdentifierInput taxCategory;

  private List<DeliveryDraft> deliveries = Collections.emptyList();

  private ResourceIdentifierInput shippingMethod;

  private DiscountedLineItemPriceDraft discountedPrice;

  private ShippingMethodState shippingMethodState = ShippingMethodState.MatchesCart;

  public ShippingInfoImportDraft() {
  }

  public ShippingInfoImportDraft(String shippingMethodName, MoneyInput price,
      ShippingRateDraft shippingRate, TaxRateInput taxRate, ResourceIdentifierInput taxCategory,
      List<DeliveryDraft> deliveries, ResourceIdentifierInput shippingMethod,
      DiscountedLineItemPriceDraft discountedPrice, ShippingMethodState shippingMethodState) {
    this.shippingMethodName = shippingMethodName;
    this.price = price;
    this.shippingRate = shippingRate;
    this.taxRate = taxRate;
    this.taxCategory = taxCategory;
    this.deliveries = deliveries;
    this.shippingMethod = shippingMethod;
    this.discountedPrice = discountedPrice;
    this.shippingMethodState = shippingMethodState;
  }

  public String getShippingMethodName() {
    return shippingMethodName;
  }

  public void setShippingMethodName(String shippingMethodName) {
    this.shippingMethodName = shippingMethodName;
  }

  public MoneyInput getPrice() {
    return price;
  }

  public void setPrice(MoneyInput price) {
    this.price = price;
  }

  public ShippingRateDraft getShippingRate() {
    return shippingRate;
  }

  public void setShippingRate(ShippingRateDraft shippingRate) {
    this.shippingRate = shippingRate;
  }

  public TaxRateInput getTaxRate() {
    return taxRate;
  }

  public void setTaxRate(TaxRateInput taxRate) {
    this.taxRate = taxRate;
  }

  public ResourceIdentifierInput getTaxCategory() {
    return taxCategory;
  }

  public void setTaxCategory(ResourceIdentifierInput taxCategory) {
    this.taxCategory = taxCategory;
  }

  public List<DeliveryDraft> getDeliveries() {
    return deliveries;
  }

  public void setDeliveries(List<DeliveryDraft> deliveries) {
    this.deliveries = deliveries;
  }

  public ResourceIdentifierInput getShippingMethod() {
    return shippingMethod;
  }

  public void setShippingMethod(ResourceIdentifierInput shippingMethod) {
    this.shippingMethod = shippingMethod;
  }

  public DiscountedLineItemPriceDraft getDiscountedPrice() {
    return discountedPrice;
  }

  public void setDiscountedPrice(DiscountedLineItemPriceDraft discountedPrice) {
    this.discountedPrice = discountedPrice;
  }

  public ShippingMethodState getShippingMethodState() {
    return shippingMethodState;
  }

  public void setShippingMethodState(ShippingMethodState shippingMethodState) {
    this.shippingMethodState = shippingMethodState;
  }

  @Override
  public String toString() {
    return "ShippingInfoImportDraft{shippingMethodName='" + shippingMethodName + "', price='" + price + "', shippingRate='" + shippingRate + "', taxRate='" + taxRate + "', taxCategory='" + taxCategory + "', deliveries='" + deliveries + "', shippingMethod='" + shippingMethod + "', discountedPrice='" + discountedPrice + "', shippingMethodState='" + shippingMethodState + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ShippingInfoImportDraft that = (ShippingInfoImportDraft) o;
    return Objects.equals(shippingMethodName, that.shippingMethodName) &&
        Objects.equals(price, that.price) &&
        Objects.equals(shippingRate, that.shippingRate) &&
        Objects.equals(taxRate, that.taxRate) &&
        Objects.equals(taxCategory, that.taxCategory) &&
        Objects.equals(deliveries, that.deliveries) &&
        Objects.equals(shippingMethod, that.shippingMethod) &&
        Objects.equals(discountedPrice, that.discountedPrice) &&
        Objects.equals(shippingMethodState, that.shippingMethodState);
  }

  @Override
  public int hashCode() {
    return Objects.hash(shippingMethodName, price, shippingRate, taxRate, taxCategory, deliveries, shippingMethod, discountedPrice, shippingMethodState);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String shippingMethodName;

    private MoneyInput price;

    private ShippingRateDraft shippingRate;

    private TaxRateInput taxRate;

    private ResourceIdentifierInput taxCategory;

    private List<DeliveryDraft> deliveries = Collections.emptyList();

    private ResourceIdentifierInput shippingMethod;

    private DiscountedLineItemPriceDraft discountedPrice;

    private ShippingMethodState shippingMethodState = ShippingMethodState.MatchesCart;

    public ShippingInfoImportDraft build() {
      ShippingInfoImportDraft result = new ShippingInfoImportDraft();
      result.shippingMethodName = this.shippingMethodName;
      result.price = this.price;
      result.shippingRate = this.shippingRate;
      result.taxRate = this.taxRate;
      result.taxCategory = this.taxCategory;
      result.deliveries = this.deliveries;
      result.shippingMethod = this.shippingMethod;
      result.discountedPrice = this.discountedPrice;
      result.shippingMethodState = this.shippingMethodState;
      return result;
    }

    public Builder shippingMethodName(String shippingMethodName) {
      this.shippingMethodName = shippingMethodName;
      return this;
    }

    public Builder price(MoneyInput price) {
      this.price = price;
      return this;
    }

    public Builder shippingRate(ShippingRateDraft shippingRate) {
      this.shippingRate = shippingRate;
      return this;
    }

    public Builder taxRate(TaxRateInput taxRate) {
      this.taxRate = taxRate;
      return this;
    }

    public Builder taxCategory(ResourceIdentifierInput taxCategory) {
      this.taxCategory = taxCategory;
      return this;
    }

    public Builder deliveries(List<DeliveryDraft> deliveries) {
      this.deliveries = deliveries;
      return this;
    }

    public Builder shippingMethod(ResourceIdentifierInput shippingMethod) {
      this.shippingMethod = shippingMethod;
      return this;
    }

    public Builder discountedPrice(DiscountedLineItemPriceDraft discountedPrice) {
      this.discountedPrice = discountedPrice;
      return this;
    }

    public Builder shippingMethodState(ShippingMethodState shippingMethodState) {
      this.shippingMethodState = shippingMethodState;
      return this;
    }
  }
}
