package com.commercetools.graphql.api.types;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class ShippingMethodDraft {
  private String name;

  private List<LocalizedStringItemInputType> localizedName;

  /**
   * The usage of parameter 'description' is deprecated in favor of using 'localizedDescription'
   */
  private String description;

  private List<LocalizedStringItemInputType> localizedDescription;

  private ResourceIdentifierInput taxCategory;

  private List<ZoneRateDraft> zoneRates = Collections.emptyList();

  private Boolean active;

  private Boolean isDefault;

  private String predicate;

  private String key;

  private CustomFieldsDraft custom;

  public ShippingMethodDraft() {
  }

  public ShippingMethodDraft(String name, List<LocalizedStringItemInputType> localizedName,
      String description, List<LocalizedStringItemInputType> localizedDescription,
      ResourceIdentifierInput taxCategory, List<ZoneRateDraft> zoneRates, Boolean active,
      Boolean isDefault, String predicate, String key, CustomFieldsDraft custom) {
    this.name = name;
    this.localizedName = localizedName;
    this.description = description;
    this.localizedDescription = localizedDescription;
    this.taxCategory = taxCategory;
    this.zoneRates = zoneRates;
    this.active = active;
    this.isDefault = isDefault;
    this.predicate = predicate;
    this.key = key;
    this.custom = custom;
  }

  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public List<LocalizedStringItemInputType> getLocalizedName() {
    return localizedName;
  }

  public void setLocalizedName(List<LocalizedStringItemInputType> localizedName) {
    this.localizedName = localizedName;
  }

  /**
   * The usage of parameter 'description' is deprecated in favor of using 'localizedDescription'
   */
  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }

  public List<LocalizedStringItemInputType> getLocalizedDescription() {
    return localizedDescription;
  }

  public void setLocalizedDescription(List<LocalizedStringItemInputType> localizedDescription) {
    this.localizedDescription = localizedDescription;
  }

  public ResourceIdentifierInput getTaxCategory() {
    return taxCategory;
  }

  public void setTaxCategory(ResourceIdentifierInput taxCategory) {
    this.taxCategory = taxCategory;
  }

  public List<ZoneRateDraft> getZoneRates() {
    return zoneRates;
  }

  public void setZoneRates(List<ZoneRateDraft> zoneRates) {
    this.zoneRates = zoneRates;
  }

  public Boolean getActive() {
    return active;
  }

  public void setActive(Boolean active) {
    this.active = active;
  }

  public Boolean getIsDefault() {
    return isDefault;
  }

  public void setIsDefault(Boolean isDefault) {
    this.isDefault = isDefault;
  }

  public String getPredicate() {
    return predicate;
  }

  public void setPredicate(String predicate) {
    this.predicate = predicate;
  }

  public String getKey() {
    return key;
  }

  public void setKey(String key) {
    this.key = key;
  }

  public CustomFieldsDraft getCustom() {
    return custom;
  }

  public void setCustom(CustomFieldsDraft custom) {
    this.custom = custom;
  }

  @Override
  public String toString() {
    return "ShippingMethodDraft{name='" + name + "', localizedName='" + localizedName + "', description='" + description + "', localizedDescription='" + localizedDescription + "', taxCategory='" + taxCategory + "', zoneRates='" + zoneRates + "', active='" + active + "', isDefault='" + isDefault + "', predicate='" + predicate + "', key='" + key + "', custom='" + custom + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ShippingMethodDraft that = (ShippingMethodDraft) o;
    return Objects.equals(name, that.name) &&
        Objects.equals(localizedName, that.localizedName) &&
        Objects.equals(description, that.description) &&
        Objects.equals(localizedDescription, that.localizedDescription) &&
        Objects.equals(taxCategory, that.taxCategory) &&
        Objects.equals(zoneRates, that.zoneRates) &&
        Objects.equals(active, that.active) &&
        Objects.equals(isDefault, that.isDefault) &&
        Objects.equals(predicate, that.predicate) &&
        Objects.equals(key, that.key) &&
        Objects.equals(custom, that.custom);
  }

  @Override
  public int hashCode() {
    return Objects.hash(name, localizedName, description, localizedDescription, taxCategory, zoneRates, active, isDefault, predicate, key, custom);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String name;

    private List<LocalizedStringItemInputType> localizedName;

    /**
     * The usage of parameter 'description' is deprecated in favor of using 'localizedDescription'
     */
    private String description;

    private List<LocalizedStringItemInputType> localizedDescription;

    private ResourceIdentifierInput taxCategory;

    private List<ZoneRateDraft> zoneRates = Collections.emptyList();

    private Boolean active;

    private Boolean isDefault;

    private String predicate;

    private String key;

    private CustomFieldsDraft custom;

    public ShippingMethodDraft build() {
      ShippingMethodDraft result = new ShippingMethodDraft();
      result.name = this.name;
      result.localizedName = this.localizedName;
      result.description = this.description;
      result.localizedDescription = this.localizedDescription;
      result.taxCategory = this.taxCategory;
      result.zoneRates = this.zoneRates;
      result.active = this.active;
      result.isDefault = this.isDefault;
      result.predicate = this.predicate;
      result.key = this.key;
      result.custom = this.custom;
      return result;
    }

    public Builder name(String name) {
      this.name = name;
      return this;
    }

    public Builder localizedName(List<LocalizedStringItemInputType> localizedName) {
      this.localizedName = localizedName;
      return this;
    }

    /**
     * The usage of parameter 'description' is deprecated in favor of using 'localizedDescription'
     */
    public Builder description(String description) {
      this.description = description;
      return this;
    }

    public Builder localizedDescription(List<LocalizedStringItemInputType> localizedDescription) {
      this.localizedDescription = localizedDescription;
      return this;
    }

    public Builder taxCategory(ResourceIdentifierInput taxCategory) {
      this.taxCategory = taxCategory;
      return this;
    }

    public Builder zoneRates(List<ZoneRateDraft> zoneRates) {
      this.zoneRates = zoneRates;
      return this;
    }

    public Builder active(Boolean active) {
      this.active = active;
      return this;
    }

    public Builder isDefault(Boolean isDefault) {
      this.isDefault = isDefault;
      return this;
    }

    public Builder predicate(String predicate) {
      this.predicate = predicate;
      return this;
    }

    public Builder key(String key) {
      this.key = key;
      return this;
    }

    public Builder custom(CustomFieldsDraft custom) {
      this.custom = custom;
      return this;
    }
  }
}
