package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class ShippingMethodLimitsProjection {
  private ShippingMethodLimitWithCurrent total;

  public ShippingMethodLimitsProjection() {
  }

  public ShippingMethodLimitsProjection(ShippingMethodLimitWithCurrent total) {
    this.total = total;
  }

  public ShippingMethodLimitWithCurrent getTotal() {
    return total;
  }

  public void setTotal(ShippingMethodLimitWithCurrent total) {
    this.total = total;
  }

  @Override
  public String toString() {
    return "ShippingMethodLimitsProjection{total='" + total + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ShippingMethodLimitsProjection that = (ShippingMethodLimitsProjection) o;
    return Objects.equals(total, that.total);
  }

  @Override
  public int hashCode() {
    return Objects.hash(total);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private ShippingMethodLimitWithCurrent total;

    public ShippingMethodLimitsProjection build() {
      ShippingMethodLimitsProjection result = new ShippingMethodLimitsProjection();
      result.total = this.total;
      return result;
    }

    public Builder total(ShippingMethodLimitWithCurrent total) {
      this.total = total;
      return this;
    }
  }
}
