package com.commercetools.graphql.api.types;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

/**
 * Shipping Rate
 */
public class ShippingRate {
  private Money price;

  private Money freeAbove;

  private Boolean isMatching;

  private List<ShippingRatePriceTier> tiers;

  public ShippingRate() {
  }

  public ShippingRate(Money price, Money freeAbove, Boolean isMatching,
      List<ShippingRatePriceTier> tiers) {
    this.price = price;
    this.freeAbove = freeAbove;
    this.isMatching = isMatching;
    this.tiers = tiers;
  }

  public Money getPrice() {
    return price;
  }

  public void setPrice(Money price) {
    this.price = price;
  }

  public Money getFreeAbove() {
    return freeAbove;
  }

  public void setFreeAbove(Money freeAbove) {
    this.freeAbove = freeAbove;
  }

  public Boolean getIsMatching() {
    return isMatching;
  }

  public void setIsMatching(Boolean isMatching) {
    this.isMatching = isMatching;
  }

  public List<ShippingRatePriceTier> getTiers() {
    return tiers;
  }

  public void setTiers(List<ShippingRatePriceTier> tiers) {
    this.tiers = tiers;
  }

  @Override
  public String toString() {
    return "ShippingRate{price='" + price + "', freeAbove='" + freeAbove + "', isMatching='" + isMatching + "', tiers='" + tiers + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ShippingRate that = (ShippingRate) o;
    return Objects.equals(price, that.price) &&
        Objects.equals(freeAbove, that.freeAbove) &&
        Objects.equals(isMatching, that.isMatching) &&
        Objects.equals(tiers, that.tiers);
  }

  @Override
  public int hashCode() {
    return Objects.hash(price, freeAbove, isMatching, tiers);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private Money price;

    private Money freeAbove;

    private Boolean isMatching;

    private List<ShippingRatePriceTier> tiers;

    public ShippingRate build() {
      ShippingRate result = new ShippingRate();
      result.price = this.price;
      result.freeAbove = this.freeAbove;
      result.isMatching = this.isMatching;
      result.tiers = this.tiers;
      return result;
    }

    public Builder price(Money price) {
      this.price = price;
      return this;
    }

    public Builder freeAbove(Money freeAbove) {
      this.freeAbove = freeAbove;
      return this;
    }

    public Builder isMatching(Boolean isMatching) {
      this.isMatching = isMatching;
      return this;
    }

    public Builder tiers(List<ShippingRatePriceTier> tiers) {
      this.tiers = tiers;
      return this;
    }
  }
}
