package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class ShippingRateCartValuePriceTier implements com.commercetools.graphql.api.types.ShippingRatePriceTier {
  private Integer minimumCentAmount;

  private Money price;

  private Boolean isMatching;

  private String type;

  public ShippingRateCartValuePriceTier() {
  }

  public ShippingRateCartValuePriceTier(Integer minimumCentAmount, Money price, Boolean isMatching,
      String type) {
    this.minimumCentAmount = minimumCentAmount;
    this.price = price;
    this.isMatching = isMatching;
    this.type = type;
  }

  public Integer getMinimumCentAmount() {
    return minimumCentAmount;
  }

  public void setMinimumCentAmount(Integer minimumCentAmount) {
    this.minimumCentAmount = minimumCentAmount;
  }

  public Money getPrice() {
    return price;
  }

  public void setPrice(Money price) {
    this.price = price;
  }

  public Boolean getIsMatching() {
    return isMatching;
  }

  public void setIsMatching(Boolean isMatching) {
    this.isMatching = isMatching;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "ShippingRateCartValuePriceTier{minimumCentAmount='" + minimumCentAmount + "', price='" + price + "', isMatching='" + isMatching + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ShippingRateCartValuePriceTier that = (ShippingRateCartValuePriceTier) o;
    return Objects.equals(minimumCentAmount, that.minimumCentAmount) &&
        Objects.equals(price, that.price) &&
        Objects.equals(isMatching, that.isMatching) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(minimumCentAmount, price, isMatching, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private Integer minimumCentAmount;

    private Money price;

    private Boolean isMatching;

    private String type;

    public ShippingRateCartValuePriceTier build() {
      ShippingRateCartValuePriceTier result = new ShippingRateCartValuePriceTier();
      result.minimumCentAmount = this.minimumCentAmount;
      result.price = this.price;
      result.isMatching = this.isMatching;
      result.type = this.type;
      return result;
    }

    public Builder minimumCentAmount(Integer minimumCentAmount) {
      this.minimumCentAmount = minimumCentAmount;
      return this;
    }

    public Builder price(Money price) {
      this.price = price;
      return this;
    }

    public Builder isMatching(Boolean isMatching) {
      this.isMatching = isMatching;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
