package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.String;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NAME,
    include = JsonTypeInfo.As.PROPERTY,
    property = "__typename"
)
@JsonSubTypes({
    @JsonSubTypes.Type(value = ClassificationShippingRateInput.class, name = "ClassificationShippingRateInput"),
    @JsonSubTypes.Type(value = ScoreShippingRateInput.class, name = "ScoreShippingRateInput")
})
public interface ShippingRateInput {
  String getType();

  void setType(String type);
}
