package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.String;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NAME,
    include = JsonTypeInfo.As.PROPERTY,
    property = "__typename"
)
@JsonSubTypes({
    @JsonSubTypes.Type(value = CartClassificationType.class, name = "CartClassificationType"),
    @JsonSubTypes.Type(value = CartScoreType.class, name = "CartScoreType"),
    @JsonSubTypes.Type(value = CartValueType.class, name = "CartValueType")
})
public interface ShippingRateInputType {
  String getType();

  void setType(String type);
}
