package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.String;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NAME,
    include = JsonTypeInfo.As.PROPERTY,
    property = "__typename"
)
@JsonSubTypes({
    @JsonSubTypes.Type(value = ShippingRateCartClassificationPriceTier.class, name = "ShippingRateCartClassificationPriceTier"),
    @JsonSubTypes.Type(value = ShippingRateCartScorePriceTier.class, name = "ShippingRateCartScorePriceTier"),
    @JsonSubTypes.Type(value = ShippingRateCartValuePriceTier.class, name = "ShippingRateCartValuePriceTier")
})
public interface ShippingRatePriceTier {
  String getType();

  void setType(String type);
}
