package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class ShippingRatePriceTierCartClassificationDraft {
  private String value;

  private MoneyDraft price;

  public ShippingRatePriceTierCartClassificationDraft() {
  }

  public ShippingRatePriceTierCartClassificationDraft(String value, MoneyDraft price) {
    this.value = value;
    this.price = price;
  }

  public String getValue() {
    return value;
  }

  public void setValue(String value) {
    this.value = value;
  }

  public MoneyDraft getPrice() {
    return price;
  }

  public void setPrice(MoneyDraft price) {
    this.price = price;
  }

  @Override
  public String toString() {
    return "ShippingRatePriceTierCartClassificationDraft{value='" + value + "', price='" + price + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ShippingRatePriceTierCartClassificationDraft that = (ShippingRatePriceTierCartClassificationDraft) o;
    return Objects.equals(value, that.value) &&
        Objects.equals(price, that.price);
  }

  @Override
  public int hashCode() {
    return Objects.hash(value, price);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String value;

    private MoneyDraft price;

    public ShippingRatePriceTierCartClassificationDraft build() {
      ShippingRatePriceTierCartClassificationDraft result = new ShippingRatePriceTierCartClassificationDraft();
      result.value = this.value;
      result.price = this.price;
      return result;
    }

    public Builder value(String value) {
      this.value = value;
      return this;
    }

    public Builder price(MoneyDraft price) {
      this.price = price;
      return this;
    }
  }
}
