package com.commercetools.graphql.api.types;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class ShippingRatePriceTierCartValueDraft {
  private Integer minimumCentAmount;

  private MoneyDraft price;

  public ShippingRatePriceTierCartValueDraft() {
  }

  public ShippingRatePriceTierCartValueDraft(Integer minimumCentAmount, MoneyDraft price) {
    this.minimumCentAmount = minimumCentAmount;
    this.price = price;
  }

  public Integer getMinimumCentAmount() {
    return minimumCentAmount;
  }

  public void setMinimumCentAmount(Integer minimumCentAmount) {
    this.minimumCentAmount = minimumCentAmount;
  }

  public MoneyDraft getPrice() {
    return price;
  }

  public void setPrice(MoneyDraft price) {
    this.price = price;
  }

  @Override
  public String toString() {
    return "ShippingRatePriceTierCartValueDraft{minimumCentAmount='" + minimumCentAmount + "', price='" + price + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ShippingRatePriceTierCartValueDraft that = (ShippingRatePriceTierCartValueDraft) o;
    return Objects.equals(minimumCentAmount, that.minimumCentAmount) &&
        Objects.equals(price, that.price);
  }

  @Override
  public int hashCode() {
    return Objects.hash(minimumCentAmount, price);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private Integer minimumCentAmount;

    private MoneyDraft price;

    public ShippingRatePriceTierCartValueDraft build() {
      ShippingRatePriceTierCartValueDraft result = new ShippingRatePriceTierCartValueDraft();
      result.minimumCentAmount = this.minimumCentAmount;
      result.price = this.price;
      return result;
    }

    public Builder minimumCentAmount(Integer minimumCentAmount) {
      this.minimumCentAmount = minimumCentAmount;
      return this;
    }

    public Builder price(MoneyDraft price) {
      this.price = price;
      return this;
    }
  }
}
