package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class ShippingRatePriceTierDraft {
  private ShippingRatePriceTierCartValueDraft CartValue;

  private ShippingRatePriceTierCartClassificationDraft CartClassification;

  private ShippingRatePriceTierCartScoreDraft CartScore;

  public ShippingRatePriceTierDraft() {
  }

  public ShippingRatePriceTierDraft(ShippingRatePriceTierCartValueDraft CartValue,
      ShippingRatePriceTierCartClassificationDraft CartClassification,
      ShippingRatePriceTierCartScoreDraft CartScore) {
    this.CartValue = CartValue;
    this.CartClassification = CartClassification;
    this.CartScore = CartScore;
  }

  public ShippingRatePriceTierCartValueDraft getCartValue() {
    return CartValue;
  }

  public void setCartValue(ShippingRatePriceTierCartValueDraft CartValue) {
    this.CartValue = CartValue;
  }

  public ShippingRatePriceTierCartClassificationDraft getCartClassification() {
    return CartClassification;
  }

  public void setCartClassification(
      ShippingRatePriceTierCartClassificationDraft CartClassification) {
    this.CartClassification = CartClassification;
  }

  public ShippingRatePriceTierCartScoreDraft getCartScore() {
    return CartScore;
  }

  public void setCartScore(ShippingRatePriceTierCartScoreDraft CartScore) {
    this.CartScore = CartScore;
  }

  @Override
  public String toString() {
    return "ShippingRatePriceTierDraft{CartValue='" + CartValue + "', CartClassification='" + CartClassification + "', CartScore='" + CartScore + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ShippingRatePriceTierDraft that = (ShippingRatePriceTierDraft) o;
    return Objects.equals(CartValue, that.CartValue) &&
        Objects.equals(CartClassification, that.CartClassification) &&
        Objects.equals(CartScore, that.CartScore);
  }

  @Override
  public int hashCode() {
    return Objects.hash(CartValue, CartClassification, CartScore);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private ShippingRatePriceTierCartValueDraft CartValue;

    private ShippingRatePriceTierCartClassificationDraft CartClassification;

    private ShippingRatePriceTierCartScoreDraft CartScore;

    public ShippingRatePriceTierDraft build() {
      ShippingRatePriceTierDraft result = new ShippingRatePriceTierDraft();
      result.CartValue = this.CartValue;
      result.CartClassification = this.CartClassification;
      result.CartScore = this.CartScore;
      return result;
    }

    public Builder CartValue(ShippingRatePriceTierCartValueDraft CartValue) {
      this.CartValue = CartValue;
      return this;
    }

    public Builder CartClassification(
        ShippingRatePriceTierCartClassificationDraft CartClassification) {
      this.CartClassification = CartClassification;
      return this;
    }

    public Builder CartScore(ShippingRatePriceTierCartScoreDraft CartScore) {
      this.CartScore = CartScore;
      return this;
    }
  }
}
