package com.commercetools.graphql.api.types;

import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class ShippingTargetDraftType {
  private String addressKey;

  private Long quantity;

  private String shippingMethodKey;

  public ShippingTargetDraftType() {
  }

  public ShippingTargetDraftType(String addressKey, Long quantity, String shippingMethodKey) {
    this.addressKey = addressKey;
    this.quantity = quantity;
    this.shippingMethodKey = shippingMethodKey;
  }

  public String getAddressKey() {
    return addressKey;
  }

  public void setAddressKey(String addressKey) {
    this.addressKey = addressKey;
  }

  public Long getQuantity() {
    return quantity;
  }

  public void setQuantity(Long quantity) {
    this.quantity = quantity;
  }

  public String getShippingMethodKey() {
    return shippingMethodKey;
  }

  public void setShippingMethodKey(String shippingMethodKey) {
    this.shippingMethodKey = shippingMethodKey;
  }

  @Override
  public String toString() {
    return "ShippingTargetDraftType{addressKey='" + addressKey + "', quantity='" + quantity + "', shippingMethodKey='" + shippingMethodKey + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ShippingTargetDraftType that = (ShippingTargetDraftType) o;
    return Objects.equals(addressKey, that.addressKey) &&
        Objects.equals(quantity, that.quantity) &&
        Objects.equals(shippingMethodKey, that.shippingMethodKey);
  }

  @Override
  public int hashCode() {
    return Objects.hash(addressKey, quantity, shippingMethodKey);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String addressKey;

    private Long quantity;

    private String shippingMethodKey;

    public ShippingTargetDraftType build() {
      ShippingTargetDraftType result = new ShippingTargetDraftType();
      result.addressKey = this.addressKey;
      result.quantity = this.quantity;
      result.shippingMethodKey = this.shippingMethodKey;
      return result;
    }

    public Builder addressKey(String addressKey) {
      this.addressKey = addressKey;
      return this;
    }

    public Builder quantity(Long quantity) {
      this.quantity = quantity;
      return this;
    }

    public Builder shippingMethodKey(String shippingMethodKey) {
      this.shippingMethodKey = shippingMethodKey;
      return this;
    }
  }
}
