package com.commercetools.graphql.api.types;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class ShoppingListDraft {
  private List<LocalizedStringItemInputType> name;

  private List<LocalizedStringItemInputType> description;

  private ResourceIdentifierInput businessUnit;

  private List<ShoppingListLineItemDraft> lineItems = Collections.emptyList();

  private List<TextLineItemDraft> textLineItems = Collections.emptyList();

  private CustomFieldsDraft custom;

  private Integer deleteDaysAfterLastModification;

  private String key;

  private ResourceIdentifierInput customer;

  private List<LocalizedStringItemInputType> slug;

  private String anonymousId;

  public ShoppingListDraft() {
  }

  public ShoppingListDraft(List<LocalizedStringItemInputType> name,
      List<LocalizedStringItemInputType> description, ResourceIdentifierInput businessUnit,
      List<ShoppingListLineItemDraft> lineItems, List<TextLineItemDraft> textLineItems,
      CustomFieldsDraft custom, Integer deleteDaysAfterLastModification, String key,
      ResourceIdentifierInput customer, List<LocalizedStringItemInputType> slug,
      String anonymousId) {
    this.name = name;
    this.description = description;
    this.businessUnit = businessUnit;
    this.lineItems = lineItems;
    this.textLineItems = textLineItems;
    this.custom = custom;
    this.deleteDaysAfterLastModification = deleteDaysAfterLastModification;
    this.key = key;
    this.customer = customer;
    this.slug = slug;
    this.anonymousId = anonymousId;
  }

  public List<LocalizedStringItemInputType> getName() {
    return name;
  }

  public void setName(List<LocalizedStringItemInputType> name) {
    this.name = name;
  }

  public List<LocalizedStringItemInputType> getDescription() {
    return description;
  }

  public void setDescription(List<LocalizedStringItemInputType> description) {
    this.description = description;
  }

  public ResourceIdentifierInput getBusinessUnit() {
    return businessUnit;
  }

  public void setBusinessUnit(ResourceIdentifierInput businessUnit) {
    this.businessUnit = businessUnit;
  }

  public List<ShoppingListLineItemDraft> getLineItems() {
    return lineItems;
  }

  public void setLineItems(List<ShoppingListLineItemDraft> lineItems) {
    this.lineItems = lineItems;
  }

  public List<TextLineItemDraft> getTextLineItems() {
    return textLineItems;
  }

  public void setTextLineItems(List<TextLineItemDraft> textLineItems) {
    this.textLineItems = textLineItems;
  }

  public CustomFieldsDraft getCustom() {
    return custom;
  }

  public void setCustom(CustomFieldsDraft custom) {
    this.custom = custom;
  }

  public Integer getDeleteDaysAfterLastModification() {
    return deleteDaysAfterLastModification;
  }

  public void setDeleteDaysAfterLastModification(Integer deleteDaysAfterLastModification) {
    this.deleteDaysAfterLastModification = deleteDaysAfterLastModification;
  }

  public String getKey() {
    return key;
  }

  public void setKey(String key) {
    this.key = key;
  }

  public ResourceIdentifierInput getCustomer() {
    return customer;
  }

  public void setCustomer(ResourceIdentifierInput customer) {
    this.customer = customer;
  }

  public List<LocalizedStringItemInputType> getSlug() {
    return slug;
  }

  public void setSlug(List<LocalizedStringItemInputType> slug) {
    this.slug = slug;
  }

  public String getAnonymousId() {
    return anonymousId;
  }

  public void setAnonymousId(String anonymousId) {
    this.anonymousId = anonymousId;
  }

  @Override
  public String toString() {
    return "ShoppingListDraft{name='" + name + "', description='" + description + "', businessUnit='" + businessUnit + "', lineItems='" + lineItems + "', textLineItems='" + textLineItems + "', custom='" + custom + "', deleteDaysAfterLastModification='" + deleteDaysAfterLastModification + "', key='" + key + "', customer='" + customer + "', slug='" + slug + "', anonymousId='" + anonymousId + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ShoppingListDraft that = (ShoppingListDraft) o;
    return Objects.equals(name, that.name) &&
        Objects.equals(description, that.description) &&
        Objects.equals(businessUnit, that.businessUnit) &&
        Objects.equals(lineItems, that.lineItems) &&
        Objects.equals(textLineItems, that.textLineItems) &&
        Objects.equals(custom, that.custom) &&
        Objects.equals(deleteDaysAfterLastModification, that.deleteDaysAfterLastModification) &&
        Objects.equals(key, that.key) &&
        Objects.equals(customer, that.customer) &&
        Objects.equals(slug, that.slug) &&
        Objects.equals(anonymousId, that.anonymousId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(name, description, businessUnit, lineItems, textLineItems, custom, deleteDaysAfterLastModification, key, customer, slug, anonymousId);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private List<LocalizedStringItemInputType> name;

    private List<LocalizedStringItemInputType> description;

    private ResourceIdentifierInput businessUnit;

    private List<ShoppingListLineItemDraft> lineItems = Collections.emptyList();

    private List<TextLineItemDraft> textLineItems = Collections.emptyList();

    private CustomFieldsDraft custom;

    private Integer deleteDaysAfterLastModification;

    private String key;

    private ResourceIdentifierInput customer;

    private List<LocalizedStringItemInputType> slug;

    private String anonymousId;

    public ShoppingListDraft build() {
      ShoppingListDraft result = new ShoppingListDraft();
      result.name = this.name;
      result.description = this.description;
      result.businessUnit = this.businessUnit;
      result.lineItems = this.lineItems;
      result.textLineItems = this.textLineItems;
      result.custom = this.custom;
      result.deleteDaysAfterLastModification = this.deleteDaysAfterLastModification;
      result.key = this.key;
      result.customer = this.customer;
      result.slug = this.slug;
      result.anonymousId = this.anonymousId;
      return result;
    }

    public Builder name(List<LocalizedStringItemInputType> name) {
      this.name = name;
      return this;
    }

    public Builder description(List<LocalizedStringItemInputType> description) {
      this.description = description;
      return this;
    }

    public Builder businessUnit(ResourceIdentifierInput businessUnit) {
      this.businessUnit = businessUnit;
      return this;
    }

    public Builder lineItems(List<ShoppingListLineItemDraft> lineItems) {
      this.lineItems = lineItems;
      return this;
    }

    public Builder textLineItems(List<TextLineItemDraft> textLineItems) {
      this.textLineItems = textLineItems;
      return this;
    }

    public Builder custom(CustomFieldsDraft custom) {
      this.custom = custom;
      return this;
    }

    public Builder deleteDaysAfterLastModification(Integer deleteDaysAfterLastModification) {
      this.deleteDaysAfterLastModification = deleteDaysAfterLastModification;
      return this;
    }

    public Builder key(String key) {
      this.key = key;
      return this;
    }

    public Builder customer(ResourceIdentifierInput customer) {
      this.customer = customer;
      return this;
    }

    public Builder slug(List<LocalizedStringItemInputType> slug) {
      this.slug = slug;
      return this;
    }

    public Builder anonymousId(String anonymousId) {
      this.anonymousId = anonymousId;
      return this;
    }
  }
}
