package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class ShoppingListLimitsProjection {
  private Limit lineItems;

  private Limit textLineItems;

  private ShoppingListLimitWithCurrent total;

  public ShoppingListLimitsProjection() {
  }

  public ShoppingListLimitsProjection(Limit lineItems, Limit textLineItems,
      ShoppingListLimitWithCurrent total) {
    this.lineItems = lineItems;
    this.textLineItems = textLineItems;
    this.total = total;
  }

  public Limit getLineItems() {
    return lineItems;
  }

  public void setLineItems(Limit lineItems) {
    this.lineItems = lineItems;
  }

  public Limit getTextLineItems() {
    return textLineItems;
  }

  public void setTextLineItems(Limit textLineItems) {
    this.textLineItems = textLineItems;
  }

  public ShoppingListLimitWithCurrent getTotal() {
    return total;
  }

  public void setTotal(ShoppingListLimitWithCurrent total) {
    this.total = total;
  }

  @Override
  public String toString() {
    return "ShoppingListLimitsProjection{lineItems='" + lineItems + "', textLineItems='" + textLineItems + "', total='" + total + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ShoppingListLimitsProjection that = (ShoppingListLimitsProjection) o;
    return Objects.equals(lineItems, that.lineItems) &&
        Objects.equals(textLineItems, that.textLineItems) &&
        Objects.equals(total, that.total);
  }

  @Override
  public int hashCode() {
    return Objects.hash(lineItems, textLineItems, total);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private Limit lineItems;

    private Limit textLineItems;

    private ShoppingListLimitWithCurrent total;

    public ShoppingListLimitsProjection build() {
      ShoppingListLimitsProjection result = new ShoppingListLimitsProjection();
      result.lineItems = this.lineItems;
      result.textLineItems = this.textLineItems;
      result.total = this.total;
      return result;
    }

    public Builder lineItems(Limit lineItems) {
      this.lineItems = lineItems;
      return this;
    }

    public Builder textLineItems(Limit textLineItems) {
      this.textLineItems = textLineItems;
      return this;
    }

    public Builder total(ShoppingListLimitWithCurrent total) {
      this.total = total;
      return this;
    }
  }
}
