package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class ShoppingListLineItemRemoved implements com.commercetools.graphql.api.types.MessagePayload {
  private ShoppingListLineItem lineItem;

  private String type;

  public ShoppingListLineItemRemoved() {
  }

  public ShoppingListLineItemRemoved(ShoppingListLineItem lineItem, String type) {
    this.lineItem = lineItem;
    this.type = type;
  }

  public ShoppingListLineItem getLineItem() {
    return lineItem;
  }

  public void setLineItem(ShoppingListLineItem lineItem) {
    this.lineItem = lineItem;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "ShoppingListLineItemRemoved{lineItem='" + lineItem + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ShoppingListLineItemRemoved that = (ShoppingListLineItemRemoved) o;
    return Objects.equals(lineItem, that.lineItem) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(lineItem, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private ShoppingListLineItem lineItem;

    private String type;

    public ShoppingListLineItemRemoved build() {
      ShoppingListLineItemRemoved result = new ShoppingListLineItemRemoved();
      result.lineItem = this.lineItem;
      result.type = this.type;
      return result;
    }

    public Builder lineItem(ShoppingListLineItem lineItem) {
      this.lineItem = lineItem;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
