package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;

/**
 * Fields to access shopping lists. Includes direct access to a single list and searching for shopping lists.
 */
@JsonTypeInfo(
    use = JsonTypeInfo.Id.NAME,
    include = JsonTypeInfo.As.PROPERTY,
    property = "__typename"
)
@JsonSubTypes({
    @JsonSubTypes.Type(value = AsAssociate.class, name = "AsAssociate"),
    @JsonSubTypes.Type(value = InStoreMe.class, name = "InStoreMe"),
    @JsonSubTypes.Type(value = Me.class, name = "Me")
})
public interface ShoppingListQueryInterface {
  ShoppingList getShoppingList();

  void setShoppingList(ShoppingList shoppingList);

  ShoppingListQueryResult getShoppingLists();

  void setShoppingLists(ShoppingListQueryResult shoppingLists);
}
