package com.commercetools.graphql.api.types;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class ShoppingListsConfiguration {
  private Integer deleteDaysAfterLastModification;

  public ShoppingListsConfiguration() {
  }

  public ShoppingListsConfiguration(Integer deleteDaysAfterLastModification) {
    this.deleteDaysAfterLastModification = deleteDaysAfterLastModification;
  }

  public Integer getDeleteDaysAfterLastModification() {
    return deleteDaysAfterLastModification;
  }

  public void setDeleteDaysAfterLastModification(Integer deleteDaysAfterLastModification) {
    this.deleteDaysAfterLastModification = deleteDaysAfterLastModification;
  }

  @Override
  public String toString() {
    return "ShoppingListsConfiguration{deleteDaysAfterLastModification='" + deleteDaysAfterLastModification + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ShoppingListsConfiguration that = (ShoppingListsConfiguration) o;
    return Objects.equals(deleteDaysAfterLastModification, that.deleteDaysAfterLastModification);
  }

  @Override
  public int hashCode() {
    return Objects.hash(deleteDaysAfterLastModification);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private Integer deleteDaysAfterLastModification;

    public ShoppingListsConfiguration build() {
      ShoppingListsConfiguration result = new ShoppingListsConfiguration();
      result.deleteDaysAfterLastModification = this.deleteDaysAfterLastModification;
      return result;
    }

    public Builder deleteDaysAfterLastModification(Integer deleteDaysAfterLastModification) {
      this.deleteDaysAfterLastModification = deleteDaysAfterLastModification;
      return this;
    }
  }
}
