package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.String;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NAME,
    include = JsonTypeInfo.As.PROPERTY,
    property = "__typename"
)
@JsonSubTypes({
    @JsonSubTypes.Type(value = AddStagedOrderCustomLineItemOutput.class, name = "AddStagedOrderCustomLineItemOutput"),
    @JsonSubTypes.Type(value = AddStagedOrderDeliveryOutput.class, name = "AddStagedOrderDeliveryOutput"),
    @JsonSubTypes.Type(value = AddStagedOrderDiscountCodeOutput.class, name = "AddStagedOrderDiscountCodeOutput"),
    @JsonSubTypes.Type(value = AddStagedOrderItemShippingAddressOutput.class, name = "AddStagedOrderItemShippingAddressOutput"),
    @JsonSubTypes.Type(value = AddStagedOrderLineItemOutput.class, name = "AddStagedOrderLineItemOutput"),
    @JsonSubTypes.Type(value = AddStagedOrderParcelToDeliveryOutput.class, name = "AddStagedOrderParcelToDeliveryOutput"),
    @JsonSubTypes.Type(value = AddStagedOrderPaymentOutput.class, name = "AddStagedOrderPaymentOutput"),
    @JsonSubTypes.Type(value = AddStagedOrderReturnInfoOutput.class, name = "AddStagedOrderReturnInfoOutput"),
    @JsonSubTypes.Type(value = AddStagedOrderShoppingListOutput.class, name = "AddStagedOrderShoppingListOutput"),
    @JsonSubTypes.Type(value = ChangeStagedOrderCustomLineItemMoneyOutput.class, name = "ChangeStagedOrderCustomLineItemMoneyOutput"),
    @JsonSubTypes.Type(value = ChangeStagedOrderCustomLineItemQuantityOutput.class, name = "ChangeStagedOrderCustomLineItemQuantityOutput"),
    @JsonSubTypes.Type(value = ChangeStagedOrderLineItemQuantityOutput.class, name = "ChangeStagedOrderLineItemQuantityOutput"),
    @JsonSubTypes.Type(value = ChangeStagedOrderOrderStateOutput.class, name = "ChangeStagedOrderOrderStateOutput"),
    @JsonSubTypes.Type(value = ChangeStagedOrderPaymentStateOutput.class, name = "ChangeStagedOrderPaymentStateOutput"),
    @JsonSubTypes.Type(value = ChangeStagedOrderShipmentStateOutput.class, name = "ChangeStagedOrderShipmentStateOutput"),
    @JsonSubTypes.Type(value = ChangeStagedOrderTaxCalculationModeOutput.class, name = "ChangeStagedOrderTaxCalculationModeOutput"),
    @JsonSubTypes.Type(value = ChangeStagedOrderTaxModeOutput.class, name = "ChangeStagedOrderTaxModeOutput"),
    @JsonSubTypes.Type(value = ChangeStagedOrderTaxRoundingModeOutput.class, name = "ChangeStagedOrderTaxRoundingModeOutput"),
    @JsonSubTypes.Type(value = ImportStagedOrderCustomLineItemStateOutput.class, name = "ImportStagedOrderCustomLineItemStateOutput"),
    @JsonSubTypes.Type(value = ImportStagedOrderLineItemStateOutput.class, name = "ImportStagedOrderLineItemStateOutput"),
    @JsonSubTypes.Type(value = RemoveStagedOrderCustomLineItemOutput.class, name = "RemoveStagedOrderCustomLineItemOutput"),
    @JsonSubTypes.Type(value = RemoveStagedOrderDeliveryOutput.class, name = "RemoveStagedOrderDeliveryOutput"),
    @JsonSubTypes.Type(value = RemoveStagedOrderDiscountCodeOutput.class, name = "RemoveStagedOrderDiscountCodeOutput"),
    @JsonSubTypes.Type(value = RemoveStagedOrderItemShippingAddressOutput.class, name = "RemoveStagedOrderItemShippingAddressOutput"),
    @JsonSubTypes.Type(value = RemoveStagedOrderLineItemOutput.class, name = "RemoveStagedOrderLineItemOutput"),
    @JsonSubTypes.Type(value = RemoveStagedOrderParcelFromDeliveryOutput.class, name = "RemoveStagedOrderParcelFromDeliveryOutput"),
    @JsonSubTypes.Type(value = RemoveStagedOrderPaymentOutput.class, name = "RemoveStagedOrderPaymentOutput"),
    @JsonSubTypes.Type(value = SetStagedOrderBillingAddressCustomFieldOutput.class, name = "SetStagedOrderBillingAddressCustomFieldOutput"),
    @JsonSubTypes.Type(value = SetStagedOrderBillingAddressCustomTypeOutput.class, name = "SetStagedOrderBillingAddressCustomTypeOutput"),
    @JsonSubTypes.Type(value = SetStagedOrderBillingAddressOutput.class, name = "SetStagedOrderBillingAddressOutput"),
    @JsonSubTypes.Type(value = SetStagedOrderBusinessUnitOutput.class, name = "SetStagedOrderBusinessUnitOutput"),
    @JsonSubTypes.Type(value = SetStagedOrderCountryOutput.class, name = "SetStagedOrderCountryOutput"),
    @JsonSubTypes.Type(value = SetStagedOrderCustomFieldOutput.class, name = "SetStagedOrderCustomFieldOutput"),
    @JsonSubTypes.Type(value = SetStagedOrderCustomLineItemCustomFieldOutput.class, name = "SetStagedOrderCustomLineItemCustomFieldOutput"),
    @JsonSubTypes.Type(value = SetStagedOrderCustomLineItemCustomTypeOutput.class, name = "SetStagedOrderCustomLineItemCustomTypeOutput"),
    @JsonSubTypes.Type(value = SetStagedOrderCustomLineItemShippingDetailsOutput.class, name = "SetStagedOrderCustomLineItemShippingDetailsOutput"),
    @JsonSubTypes.Type(value = SetStagedOrderCustomLineItemTaxAmountOutput.class, name = "SetStagedOrderCustomLineItemTaxAmountOutput"),
    @JsonSubTypes.Type(value = SetStagedOrderCustomLineItemTaxRateOutput.class, name = "SetStagedOrderCustomLineItemTaxRateOutput"),
    @JsonSubTypes.Type(value = SetStagedOrderCustomShippingMethodOutput.class, name = "SetStagedOrderCustomShippingMethodOutput"),
    @JsonSubTypes.Type(value = SetStagedOrderCustomTypeOutput.class, name = "SetStagedOrderCustomTypeOutput"),
    @JsonSubTypes.Type(value = SetStagedOrderCustomerEmailOutput.class, name = "SetStagedOrderCustomerEmailOutput"),
    @JsonSubTypes.Type(value = SetStagedOrderCustomerGroupOutput.class, name = "SetStagedOrderCustomerGroupOutput"),
    @JsonSubTypes.Type(value = SetStagedOrderCustomerIdOutput.class, name = "SetStagedOrderCustomerIdOutput"),
    @JsonSubTypes.Type(value = SetStagedOrderDeliveryAddressCustomFieldOutput.class, name = "SetStagedOrderDeliveryAddressCustomFieldOutput"),
    @JsonSubTypes.Type(value = SetStagedOrderDeliveryAddressCustomTypeOutput.class, name = "SetStagedOrderDeliveryAddressCustomTypeOutput"),
    @JsonSubTypes.Type(value = SetStagedOrderDeliveryAddressOutput.class, name = "SetStagedOrderDeliveryAddressOutput"),
    @JsonSubTypes.Type(value = SetStagedOrderDeliveryCustomFieldOutput.class, name = "SetStagedOrderDeliveryCustomFieldOutput"),
    @JsonSubTypes.Type(value = SetStagedOrderDeliveryCustomTypeOutput.class, name = "SetStagedOrderDeliveryCustomTypeOutput"),
    @JsonSubTypes.Type(value = SetStagedOrderDeliveryItemsOutput.class, name = "SetStagedOrderDeliveryItemsOutput"),
    @JsonSubTypes.Type(value = SetStagedOrderDirectDiscountsOutput.class, name = "SetStagedOrderDirectDiscountsOutput"),
    @JsonSubTypes.Type(value = SetStagedOrderItemShippingAddressCustomFieldOutput.class, name = "SetStagedOrderItemShippingAddressCustomFieldOutput"),
    @JsonSubTypes.Type(value = SetStagedOrderItemShippingAddressCustomTypeOutput.class, name = "SetStagedOrderItemShippingAddressCustomTypeOutput"),
    @JsonSubTypes.Type(value = SetStagedOrderLineItemCustomFieldOutput.class, name = "SetStagedOrderLineItemCustomFieldOutput"),
    @JsonSubTypes.Type(value = SetStagedOrderLineItemCustomTypeOutput.class, name = "SetStagedOrderLineItemCustomTypeOutput"),
    @JsonSubTypes.Type(value = SetStagedOrderLineItemDistributionChannelOutput.class, name = "SetStagedOrderLineItemDistributionChannelOutput"),
    @JsonSubTypes.Type(value = SetStagedOrderLineItemPriceOutput.class, name = "SetStagedOrderLineItemPriceOutput"),
    @JsonSubTypes.Type(value = SetStagedOrderLineItemShippingDetailsOutput.class, name = "SetStagedOrderLineItemShippingDetailsOutput"),
    @JsonSubTypes.Type(value = SetStagedOrderLineItemTaxAmountOutput.class, name = "SetStagedOrderLineItemTaxAmountOutput"),
    @JsonSubTypes.Type(value = SetStagedOrderLineItemTaxRateOutput.class, name = "SetStagedOrderLineItemTaxRateOutput"),
    @JsonSubTypes.Type(value = SetStagedOrderLineItemTotalPriceOutput.class, name = "SetStagedOrderLineItemTotalPriceOutput"),
    @JsonSubTypes.Type(value = SetStagedOrderLocaleOutput.class, name = "SetStagedOrderLocaleOutput"),
    @JsonSubTypes.Type(value = SetStagedOrderOrderNumberOutput.class, name = "SetStagedOrderOrderNumberOutput"),
    @JsonSubTypes.Type(value = SetStagedOrderOrderTotalTaxOutput.class, name = "SetStagedOrderOrderTotalTaxOutput"),
    @JsonSubTypes.Type(value = SetStagedOrderParcelCustomFieldOutput.class, name = "SetStagedOrderParcelCustomFieldOutput"),
    @JsonSubTypes.Type(value = SetStagedOrderParcelCustomTypeOutput.class, name = "SetStagedOrderParcelCustomTypeOutput"),
    @JsonSubTypes.Type(value = SetStagedOrderParcelItemsOutput.class, name = "SetStagedOrderParcelItemsOutput"),
    @JsonSubTypes.Type(value = SetStagedOrderParcelMeasurementsOutput.class, name = "SetStagedOrderParcelMeasurementsOutput"),
    @JsonSubTypes.Type(value = SetStagedOrderParcelTrackingDataOutput.class, name = "SetStagedOrderParcelTrackingDataOutput"),
    @JsonSubTypes.Type(value = SetStagedOrderPurchaseOrderNumberOutput.class, name = "SetStagedOrderPurchaseOrderNumberOutput"),
    @JsonSubTypes.Type(value = SetStagedOrderReturnInfoOutput.class, name = "SetStagedOrderReturnInfoOutput"),
    @JsonSubTypes.Type(value = SetStagedOrderReturnItemCustomFieldOutput.class, name = "SetStagedOrderReturnItemCustomFieldOutput"),
    @JsonSubTypes.Type(value = SetStagedOrderReturnItemCustomTypeOutput.class, name = "SetStagedOrderReturnItemCustomTypeOutput"),
    @JsonSubTypes.Type(value = SetStagedOrderReturnPaymentStateOutput.class, name = "SetStagedOrderReturnPaymentStateOutput"),
    @JsonSubTypes.Type(value = SetStagedOrderReturnShipmentStateOutput.class, name = "SetStagedOrderReturnShipmentStateOutput"),
    @JsonSubTypes.Type(value = SetStagedOrderShippingAddressAndCustomShippingMethodOutput.class, name = "SetStagedOrderShippingAddressAndCustomShippingMethodOutput"),
    @JsonSubTypes.Type(value = SetStagedOrderShippingAddressAndShippingMethodOutput.class, name = "SetStagedOrderShippingAddressAndShippingMethodOutput"),
    @JsonSubTypes.Type(value = SetStagedOrderShippingAddressCustomFieldOutput.class, name = "SetStagedOrderShippingAddressCustomFieldOutput"),
    @JsonSubTypes.Type(value = SetStagedOrderShippingAddressCustomTypeOutput.class, name = "SetStagedOrderShippingAddressCustomTypeOutput"),
    @JsonSubTypes.Type(value = SetStagedOrderShippingAddressOutput.class, name = "SetStagedOrderShippingAddressOutput"),
    @JsonSubTypes.Type(value = SetStagedOrderShippingCustomFieldOutput.class, name = "SetStagedOrderShippingCustomFieldOutput"),
    @JsonSubTypes.Type(value = SetStagedOrderShippingCustomTypeOutput.class, name = "SetStagedOrderShippingCustomTypeOutput"),
    @JsonSubTypes.Type(value = SetStagedOrderShippingMethodOutput.class, name = "SetStagedOrderShippingMethodOutput"),
    @JsonSubTypes.Type(value = SetStagedOrderShippingMethodTaxAmountOutput.class, name = "SetStagedOrderShippingMethodTaxAmountOutput"),
    @JsonSubTypes.Type(value = SetStagedOrderShippingMethodTaxRateOutput.class, name = "SetStagedOrderShippingMethodTaxRateOutput"),
    @JsonSubTypes.Type(value = SetStagedOrderShippingRateInputOutput.class, name = "SetStagedOrderShippingRateInputOutput"),
    @JsonSubTypes.Type(value = SetStagedOrderStoreOutput.class, name = "SetStagedOrderStoreOutput"),
    @JsonSubTypes.Type(value = TransitionStagedOrderCustomLineItemStateOutput.class, name = "TransitionStagedOrderCustomLineItemStateOutput"),
    @JsonSubTypes.Type(value = TransitionStagedOrderLineItemStateOutput.class, name = "TransitionStagedOrderLineItemStateOutput"),
    @JsonSubTypes.Type(value = TransitionStagedOrderStateOutput.class, name = "TransitionStagedOrderStateOutput"),
    @JsonSubTypes.Type(value = UpdateStagedOrderItemShippingAddressOutput.class, name = "UpdateStagedOrderItemShippingAddressOutput"),
    @JsonSubTypes.Type(value = UpdateStagedOrderSyncInfoOutput.class, name = "UpdateStagedOrderSyncInfoOutput")
})
public interface StagedOrderUpdateActionOutput {
  String getType();

  void setType(String type);
}
