package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class StagedQuoteCreated implements com.commercetools.graphql.api.types.MessagePayload {
  private StagedQuote stagedQuote;

  private String type;

  public StagedQuoteCreated() {
  }

  public StagedQuoteCreated(StagedQuote stagedQuote, String type) {
    this.stagedQuote = stagedQuote;
    this.type = type;
  }

  public StagedQuote getStagedQuote() {
    return stagedQuote;
  }

  public void setStagedQuote(StagedQuote stagedQuote) {
    this.stagedQuote = stagedQuote;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "StagedQuoteCreated{stagedQuote='" + stagedQuote + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    StagedQuoteCreated that = (StagedQuoteCreated) o;
    return Objects.equals(stagedQuote, that.stagedQuote) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(stagedQuote, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private StagedQuote stagedQuote;

    private String type;

    public StagedQuoteCreated build() {
      StagedQuoteCreated result = new StagedQuoteCreated();
      result.stagedQuote = this.stagedQuote;
      result.type = this.type;
      return result;
    }

    public Builder stagedQuote(StagedQuote stagedQuote) {
      this.stagedQuote = stagedQuote;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
