package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class StagedQuoteStateChanged implements com.commercetools.graphql.api.types.MessagePayload {
  private StagedQuoteState stagedQuoteState;

  private StagedQuoteState oldStagedQuoteState;

  private String type;

  public StagedQuoteStateChanged() {
  }

  public StagedQuoteStateChanged(StagedQuoteState stagedQuoteState,
      StagedQuoteState oldStagedQuoteState, String type) {
    this.stagedQuoteState = stagedQuoteState;
    this.oldStagedQuoteState = oldStagedQuoteState;
    this.type = type;
  }

  public StagedQuoteState getStagedQuoteState() {
    return stagedQuoteState;
  }

  public void setStagedQuoteState(StagedQuoteState stagedQuoteState) {
    this.stagedQuoteState = stagedQuoteState;
  }

  public StagedQuoteState getOldStagedQuoteState() {
    return oldStagedQuoteState;
  }

  public void setOldStagedQuoteState(StagedQuoteState oldStagedQuoteState) {
    this.oldStagedQuoteState = oldStagedQuoteState;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "StagedQuoteStateChanged{stagedQuoteState='" + stagedQuoteState + "', oldStagedQuoteState='" + oldStagedQuoteState + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    StagedQuoteStateChanged that = (StagedQuoteStateChanged) o;
    return Objects.equals(stagedQuoteState, that.stagedQuoteState) &&
        Objects.equals(oldStagedQuoteState, that.oldStagedQuoteState) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(stagedQuoteState, oldStagedQuoteState, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private StagedQuoteState stagedQuoteState;

    private StagedQuoteState oldStagedQuoteState;

    private String type;

    public StagedQuoteStateChanged build() {
      StagedQuoteStateChanged result = new StagedQuoteStateChanged();
      result.stagedQuoteState = this.stagedQuoteState;
      result.oldStagedQuoteState = this.oldStagedQuoteState;
      result.type = this.type;
      return result;
    }

    public Builder stagedQuoteState(StagedQuoteState stagedQuoteState) {
      this.stagedQuoteState = stagedQuoteState;
      return this;
    }

    public Builder oldStagedQuoteState(StagedQuoteState oldStagedQuoteState) {
      this.oldStagedQuoteState = oldStagedQuoteState;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
