package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class StagedQuoteUpdateAction {
  private ChangeStagedQuoteState changeStagedQuoteState;

  private SetStagedQuoteSellerComment setSellerComment;

  private SetStagedQuoteCustomField setCustomField;

  private SetStagedQuoteCustomType setCustomType;

  private SetStagedQuoteValidTo setValidTo;

  private TransitionStagedQuoteState transitionState;

  public StagedQuoteUpdateAction() {
  }

  public StagedQuoteUpdateAction(ChangeStagedQuoteState changeStagedQuoteState,
      SetStagedQuoteSellerComment setSellerComment, SetStagedQuoteCustomField setCustomField,
      SetStagedQuoteCustomType setCustomType, SetStagedQuoteValidTo setValidTo,
      TransitionStagedQuoteState transitionState) {
    this.changeStagedQuoteState = changeStagedQuoteState;
    this.setSellerComment = setSellerComment;
    this.setCustomField = setCustomField;
    this.setCustomType = setCustomType;
    this.setValidTo = setValidTo;
    this.transitionState = transitionState;
  }

  public ChangeStagedQuoteState getChangeStagedQuoteState() {
    return changeStagedQuoteState;
  }

  public void setChangeStagedQuoteState(ChangeStagedQuoteState changeStagedQuoteState) {
    this.changeStagedQuoteState = changeStagedQuoteState;
  }

  public SetStagedQuoteSellerComment getSetSellerComment() {
    return setSellerComment;
  }

  public void setSetSellerComment(SetStagedQuoteSellerComment setSellerComment) {
    this.setSellerComment = setSellerComment;
  }

  public SetStagedQuoteCustomField getSetCustomField() {
    return setCustomField;
  }

  public void setSetCustomField(SetStagedQuoteCustomField setCustomField) {
    this.setCustomField = setCustomField;
  }

  public SetStagedQuoteCustomType getSetCustomType() {
    return setCustomType;
  }

  public void setSetCustomType(SetStagedQuoteCustomType setCustomType) {
    this.setCustomType = setCustomType;
  }

  public SetStagedQuoteValidTo getSetValidTo() {
    return setValidTo;
  }

  public void setSetValidTo(SetStagedQuoteValidTo setValidTo) {
    this.setValidTo = setValidTo;
  }

  public TransitionStagedQuoteState getTransitionState() {
    return transitionState;
  }

  public void setTransitionState(TransitionStagedQuoteState transitionState) {
    this.transitionState = transitionState;
  }

  @Override
  public String toString() {
    return "StagedQuoteUpdateAction{changeStagedQuoteState='" + changeStagedQuoteState + "', setSellerComment='" + setSellerComment + "', setCustomField='" + setCustomField + "', setCustomType='" + setCustomType + "', setValidTo='" + setValidTo + "', transitionState='" + transitionState + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    StagedQuoteUpdateAction that = (StagedQuoteUpdateAction) o;
    return Objects.equals(changeStagedQuoteState, that.changeStagedQuoteState) &&
        Objects.equals(setSellerComment, that.setSellerComment) &&
        Objects.equals(setCustomField, that.setCustomField) &&
        Objects.equals(setCustomType, that.setCustomType) &&
        Objects.equals(setValidTo, that.setValidTo) &&
        Objects.equals(transitionState, that.transitionState);
  }

  @Override
  public int hashCode() {
    return Objects.hash(changeStagedQuoteState, setSellerComment, setCustomField, setCustomType, setValidTo, transitionState);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private ChangeStagedQuoteState changeStagedQuoteState;

    private SetStagedQuoteSellerComment setSellerComment;

    private SetStagedQuoteCustomField setCustomField;

    private SetStagedQuoteCustomType setCustomType;

    private SetStagedQuoteValidTo setValidTo;

    private TransitionStagedQuoteState transitionState;

    public StagedQuoteUpdateAction build() {
      StagedQuoteUpdateAction result = new StagedQuoteUpdateAction();
      result.changeStagedQuoteState = this.changeStagedQuoteState;
      result.setSellerComment = this.setSellerComment;
      result.setCustomField = this.setCustomField;
      result.setCustomType = this.setCustomType;
      result.setValidTo = this.setValidTo;
      result.transitionState = this.transitionState;
      return result;
    }

    public Builder changeStagedQuoteState(ChangeStagedQuoteState changeStagedQuoteState) {
      this.changeStagedQuoteState = changeStagedQuoteState;
      return this;
    }

    public Builder setSellerComment(SetStagedQuoteSellerComment setSellerComment) {
      this.setSellerComment = setSellerComment;
      return this;
    }

    public Builder setCustomField(SetStagedQuoteCustomField setCustomField) {
      this.setCustomField = setCustomField;
      return this;
    }

    public Builder setCustomType(SetStagedQuoteCustomType setCustomType) {
      this.setCustomType = setCustomType;
      return this;
    }

    public Builder setValidTo(SetStagedQuoteValidTo setValidTo) {
      this.setValidTo = setValidTo;
      return this;
    }

    public Builder transitionState(TransitionStagedQuoteState transitionState) {
      this.transitionState = transitionState;
      return this;
    }
  }
}
