package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.time.OffsetDateTime;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class StagedQuoteValidToSet implements com.commercetools.graphql.api.types.MessagePayload {
  private OffsetDateTime validTo;

  private String type;

  public StagedQuoteValidToSet() {
  }

  public StagedQuoteValidToSet(OffsetDateTime validTo, String type) {
    this.validTo = validTo;
    this.type = type;
  }

  public OffsetDateTime getValidTo() {
    return validTo;
  }

  public void setValidTo(OffsetDateTime validTo) {
    this.validTo = validTo;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "StagedQuoteValidToSet{validTo='" + validTo + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    StagedQuoteValidToSet that = (StagedQuoteValidToSet) o;
    return Objects.equals(validTo, that.validTo) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(validTo, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private OffsetDateTime validTo;

    private String type;

    public StagedQuoteValidToSet build() {
      StagedQuoteValidToSet result = new StagedQuoteValidToSet();
      result.validTo = this.validTo;
      result.type = this.type;
      return result;
    }

    public Builder validTo(OffsetDateTime validTo) {
      this.validTo = validTo;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
