package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class StagedStandalonePrice {
  private BaseMoney value;

  private DiscountedProductPriceValue discounted;

  public StagedStandalonePrice() {
  }

  public StagedStandalonePrice(BaseMoney value, DiscountedProductPriceValue discounted) {
    this.value = value;
    this.discounted = discounted;
  }

  public BaseMoney getValue() {
    return value;
  }

  public void setValue(BaseMoney value) {
    this.value = value;
  }

  public DiscountedProductPriceValue getDiscounted() {
    return discounted;
  }

  public void setDiscounted(DiscountedProductPriceValue discounted) {
    this.discounted = discounted;
  }

  @Override
  public String toString() {
    return "StagedStandalonePrice{value='" + value + "', discounted='" + discounted + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    StagedStandalonePrice that = (StagedStandalonePrice) o;
    return Objects.equals(value, that.value) &&
        Objects.equals(discounted, that.discounted);
  }

  @Override
  public int hashCode() {
    return Objects.hash(value, discounted);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private BaseMoney value;

    private DiscountedProductPriceValue discounted;

    public StagedStandalonePrice build() {
      StagedStandalonePrice result = new StagedStandalonePrice();
      result.value = this.value;
      result.discounted = this.discounted;
      return result;
    }

    public Builder value(BaseMoney value) {
      this.value = value;
      return this;
    }

    public Builder discounted(DiscountedProductPriceValue discounted) {
      this.discounted = discounted;
      return this;
    }
  }
}
