package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Boolean;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Objects;

/**
 * StandalonePrices are managed and queried through the StandalonePrices API
 * and associated to a ProductVariant through the sku field.
 */
@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class StandalonePrice implements com.commercetools.graphql.api.types.Versioned {
  private String id;

  private Long version;

  private String key;

  private String sku;

  private BaseMoney value;

  private String country;

  private Reference customerGroupRef;

  private CustomerGroup customerGroup;

  private Reference channelRef;

  private Channel channel;

  private OffsetDateTime validFrom;

  private OffsetDateTime validUntil;

  private List<ProductPriceTier> tiers;

  private DiscountedProductPriceValue discounted;

  private StagedStandalonePrice staged;

  private CustomFieldsType custom;

  private Boolean active;

  private OffsetDateTime createdAt;

  private OffsetDateTime lastModifiedAt;

  private Initiator createdBy;

  private Initiator lastModifiedBy;

  public StandalonePrice() {
  }

  public StandalonePrice(String id, Long version, String key, String sku, BaseMoney value,
      String country, Reference customerGroupRef, CustomerGroup customerGroup, Reference channelRef,
      Channel channel, OffsetDateTime validFrom, OffsetDateTime validUntil,
      List<ProductPriceTier> tiers, DiscountedProductPriceValue discounted,
      StagedStandalonePrice staged, CustomFieldsType custom, Boolean active,
      OffsetDateTime createdAt, OffsetDateTime lastModifiedAt, Initiator createdBy,
      Initiator lastModifiedBy) {
    this.id = id;
    this.version = version;
    this.key = key;
    this.sku = sku;
    this.value = value;
    this.country = country;
    this.customerGroupRef = customerGroupRef;
    this.customerGroup = customerGroup;
    this.channelRef = channelRef;
    this.channel = channel;
    this.validFrom = validFrom;
    this.validUntil = validUntil;
    this.tiers = tiers;
    this.discounted = discounted;
    this.staged = staged;
    this.custom = custom;
    this.active = active;
    this.createdAt = createdAt;
    this.lastModifiedAt = lastModifiedAt;
    this.createdBy = createdBy;
    this.lastModifiedBy = lastModifiedBy;
  }

  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }

  public Long getVersion() {
    return version;
  }

  public void setVersion(Long version) {
    this.version = version;
  }

  public String getKey() {
    return key;
  }

  public void setKey(String key) {
    this.key = key;
  }

  public String getSku() {
    return sku;
  }

  public void setSku(String sku) {
    this.sku = sku;
  }

  public BaseMoney getValue() {
    return value;
  }

  public void setValue(BaseMoney value) {
    this.value = value;
  }

  public String getCountry() {
    return country;
  }

  public void setCountry(String country) {
    this.country = country;
  }

  public Reference getCustomerGroupRef() {
    return customerGroupRef;
  }

  public void setCustomerGroupRef(Reference customerGroupRef) {
    this.customerGroupRef = customerGroupRef;
  }

  public CustomerGroup getCustomerGroup() {
    return customerGroup;
  }

  public void setCustomerGroup(CustomerGroup customerGroup) {
    this.customerGroup = customerGroup;
  }

  public Reference getChannelRef() {
    return channelRef;
  }

  public void setChannelRef(Reference channelRef) {
    this.channelRef = channelRef;
  }

  public Channel getChannel() {
    return channel;
  }

  public void setChannel(Channel channel) {
    this.channel = channel;
  }

  public OffsetDateTime getValidFrom() {
    return validFrom;
  }

  public void setValidFrom(OffsetDateTime validFrom) {
    this.validFrom = validFrom;
  }

  public OffsetDateTime getValidUntil() {
    return validUntil;
  }

  public void setValidUntil(OffsetDateTime validUntil) {
    this.validUntil = validUntil;
  }

  public List<ProductPriceTier> getTiers() {
    return tiers;
  }

  public void setTiers(List<ProductPriceTier> tiers) {
    this.tiers = tiers;
  }

  public DiscountedProductPriceValue getDiscounted() {
    return discounted;
  }

  public void setDiscounted(DiscountedProductPriceValue discounted) {
    this.discounted = discounted;
  }

  public StagedStandalonePrice getStaged() {
    return staged;
  }

  public void setStaged(StagedStandalonePrice staged) {
    this.staged = staged;
  }

  public CustomFieldsType getCustom() {
    return custom;
  }

  public void setCustom(CustomFieldsType custom) {
    this.custom = custom;
  }

  public Boolean getActive() {
    return active;
  }

  public void setActive(Boolean active) {
    this.active = active;
  }

  public OffsetDateTime getCreatedAt() {
    return createdAt;
  }

  public void setCreatedAt(OffsetDateTime createdAt) {
    this.createdAt = createdAt;
  }

  public OffsetDateTime getLastModifiedAt() {
    return lastModifiedAt;
  }

  public void setLastModifiedAt(OffsetDateTime lastModifiedAt) {
    this.lastModifiedAt = lastModifiedAt;
  }

  public Initiator getCreatedBy() {
    return createdBy;
  }

  public void setCreatedBy(Initiator createdBy) {
    this.createdBy = createdBy;
  }

  public Initiator getLastModifiedBy() {
    return lastModifiedBy;
  }

  public void setLastModifiedBy(Initiator lastModifiedBy) {
    this.lastModifiedBy = lastModifiedBy;
  }

  @Override
  public String toString() {
    return "StandalonePrice{id='" + id + "', version='" + version + "', key='" + key + "', sku='" + sku + "', value='" + value + "', country='" + country + "', customerGroupRef='" + customerGroupRef + "', customerGroup='" + customerGroup + "', channelRef='" + channelRef + "', channel='" + channel + "', validFrom='" + validFrom + "', validUntil='" + validUntil + "', tiers='" + tiers + "', discounted='" + discounted + "', staged='" + staged + "', custom='" + custom + "', active='" + active + "', createdAt='" + createdAt + "', lastModifiedAt='" + lastModifiedAt + "', createdBy='" + createdBy + "', lastModifiedBy='" + lastModifiedBy + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    StandalonePrice that = (StandalonePrice) o;
    return Objects.equals(id, that.id) &&
        Objects.equals(version, that.version) &&
        Objects.equals(key, that.key) &&
        Objects.equals(sku, that.sku) &&
        Objects.equals(value, that.value) &&
        Objects.equals(country, that.country) &&
        Objects.equals(customerGroupRef, that.customerGroupRef) &&
        Objects.equals(customerGroup, that.customerGroup) &&
        Objects.equals(channelRef, that.channelRef) &&
        Objects.equals(channel, that.channel) &&
        Objects.equals(validFrom, that.validFrom) &&
        Objects.equals(validUntil, that.validUntil) &&
        Objects.equals(tiers, that.tiers) &&
        Objects.equals(discounted, that.discounted) &&
        Objects.equals(staged, that.staged) &&
        Objects.equals(custom, that.custom) &&
        Objects.equals(active, that.active) &&
        Objects.equals(createdAt, that.createdAt) &&
        Objects.equals(lastModifiedAt, that.lastModifiedAt) &&
        Objects.equals(createdBy, that.createdBy) &&
        Objects.equals(lastModifiedBy, that.lastModifiedBy);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, version, key, sku, value, country, customerGroupRef, customerGroup, channelRef, channel, validFrom, validUntil, tiers, discounted, staged, custom, active, createdAt, lastModifiedAt, createdBy, lastModifiedBy);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String id;

    private Long version;

    private String key;

    private String sku;

    private BaseMoney value;

    private String country;

    private Reference customerGroupRef;

    private CustomerGroup customerGroup;

    private Reference channelRef;

    private Channel channel;

    private OffsetDateTime validFrom;

    private OffsetDateTime validUntil;

    private List<ProductPriceTier> tiers;

    private DiscountedProductPriceValue discounted;

    private StagedStandalonePrice staged;

    private CustomFieldsType custom;

    private Boolean active;

    private OffsetDateTime createdAt;

    private OffsetDateTime lastModifiedAt;

    private Initiator createdBy;

    private Initiator lastModifiedBy;

    public StandalonePrice build() {
      StandalonePrice result = new StandalonePrice();
      result.id = this.id;
      result.version = this.version;
      result.key = this.key;
      result.sku = this.sku;
      result.value = this.value;
      result.country = this.country;
      result.customerGroupRef = this.customerGroupRef;
      result.customerGroup = this.customerGroup;
      result.channelRef = this.channelRef;
      result.channel = this.channel;
      result.validFrom = this.validFrom;
      result.validUntil = this.validUntil;
      result.tiers = this.tiers;
      result.discounted = this.discounted;
      result.staged = this.staged;
      result.custom = this.custom;
      result.active = this.active;
      result.createdAt = this.createdAt;
      result.lastModifiedAt = this.lastModifiedAt;
      result.createdBy = this.createdBy;
      result.lastModifiedBy = this.lastModifiedBy;
      return result;
    }

    public Builder id(String id) {
      this.id = id;
      return this;
    }

    public Builder version(Long version) {
      this.version = version;
      return this;
    }

    public Builder key(String key) {
      this.key = key;
      return this;
    }

    public Builder sku(String sku) {
      this.sku = sku;
      return this;
    }

    public Builder value(BaseMoney value) {
      this.value = value;
      return this;
    }

    public Builder country(String country) {
      this.country = country;
      return this;
    }

    public Builder customerGroupRef(Reference customerGroupRef) {
      this.customerGroupRef = customerGroupRef;
      return this;
    }

    public Builder customerGroup(CustomerGroup customerGroup) {
      this.customerGroup = customerGroup;
      return this;
    }

    public Builder channelRef(Reference channelRef) {
      this.channelRef = channelRef;
      return this;
    }

    public Builder channel(Channel channel) {
      this.channel = channel;
      return this;
    }

    public Builder validFrom(OffsetDateTime validFrom) {
      this.validFrom = validFrom;
      return this;
    }

    public Builder validUntil(OffsetDateTime validUntil) {
      this.validUntil = validUntil;
      return this;
    }

    public Builder tiers(List<ProductPriceTier> tiers) {
      this.tiers = tiers;
      return this;
    }

    public Builder discounted(DiscountedProductPriceValue discounted) {
      this.discounted = discounted;
      return this;
    }

    public Builder staged(StagedStandalonePrice staged) {
      this.staged = staged;
      return this;
    }

    public Builder custom(CustomFieldsType custom) {
      this.custom = custom;
      return this;
    }

    public Builder active(Boolean active) {
      this.active = active;
      return this;
    }

    public Builder createdAt(OffsetDateTime createdAt) {
      this.createdAt = createdAt;
      return this;
    }

    public Builder lastModifiedAt(OffsetDateTime lastModifiedAt) {
      this.lastModifiedAt = lastModifiedAt;
      return this;
    }

    public Builder createdBy(Initiator createdBy) {
      this.createdBy = createdBy;
      return this;
    }

    public Builder lastModifiedBy(Initiator lastModifiedBy) {
      this.lastModifiedBy = lastModifiedBy;
      return this;
    }
  }
}
