package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class StandalonePriceActiveChanged implements com.commercetools.graphql.api.types.MessagePayload {
  private Boolean active;

  private Boolean oldActive;

  private String type;

  public StandalonePriceActiveChanged() {
  }

  public StandalonePriceActiveChanged(Boolean active, Boolean oldActive, String type) {
    this.active = active;
    this.oldActive = oldActive;
    this.type = type;
  }

  public Boolean getActive() {
    return active;
  }

  public void setActive(Boolean active) {
    this.active = active;
  }

  public Boolean getOldActive() {
    return oldActive;
  }

  public void setOldActive(Boolean oldActive) {
    this.oldActive = oldActive;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "StandalonePriceActiveChanged{active='" + active + "', oldActive='" + oldActive + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    StandalonePriceActiveChanged that = (StandalonePriceActiveChanged) o;
    return Objects.equals(active, that.active) &&
        Objects.equals(oldActive, that.oldActive) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(active, oldActive, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private Boolean active;

    private Boolean oldActive;

    private String type;

    public StandalonePriceActiveChanged build() {
      StandalonePriceActiveChanged result = new StandalonePriceActiveChanged();
      result.active = this.active;
      result.oldActive = this.oldActive;
      result.type = this.type;
      return result;
    }

    public Builder active(Boolean active) {
      this.active = active;
      return this;
    }

    public Builder oldActive(Boolean oldActive) {
      this.oldActive = oldActive;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
