package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class StandalonePriceCreated implements com.commercetools.graphql.api.types.MessagePayload {
  private StandalonePrice standalonePrice;

  private String type;

  public StandalonePriceCreated() {
  }

  public StandalonePriceCreated(StandalonePrice standalonePrice, String type) {
    this.standalonePrice = standalonePrice;
    this.type = type;
  }

  public StandalonePrice getStandalonePrice() {
    return standalonePrice;
  }

  public void setStandalonePrice(StandalonePrice standalonePrice) {
    this.standalonePrice = standalonePrice;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "StandalonePriceCreated{standalonePrice='" + standalonePrice + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    StandalonePriceCreated that = (StandalonePriceCreated) o;
    return Objects.equals(standalonePrice, that.standalonePrice) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(standalonePrice, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private StandalonePrice standalonePrice;

    private String type;

    public StandalonePriceCreated build() {
      StandalonePriceCreated result = new StandalonePriceCreated();
      result.standalonePrice = this.standalonePrice;
      result.type = this.type;
      return result;
    }

    public Builder standalonePrice(StandalonePrice standalonePrice) {
      this.standalonePrice = standalonePrice;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
