package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class StandalonePriceTierAdded implements com.commercetools.graphql.api.types.MessagePayload {
  private ProductPriceTier tier;

  private String type;

  public StandalonePriceTierAdded() {
  }

  public StandalonePriceTierAdded(ProductPriceTier tier, String type) {
    this.tier = tier;
    this.type = type;
  }

  public ProductPriceTier getTier() {
    return tier;
  }

  public void setTier(ProductPriceTier tier) {
    this.tier = tier;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "StandalonePriceTierAdded{tier='" + tier + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    StandalonePriceTierAdded that = (StandalonePriceTierAdded) o;
    return Objects.equals(tier, that.tier) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(tier, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private ProductPriceTier tier;

    private String type;

    public StandalonePriceTierAdded build() {
      StandalonePriceTierAdded result = new StandalonePriceTierAdded();
      result.tier = this.tier;
      result.type = this.type;
      return result;
    }

    public Builder tier(ProductPriceTier tier) {
      this.tier = tier;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
