package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.time.OffsetDateTime;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class StandalonePriceValidFromAndUntilSet implements com.commercetools.graphql.api.types.MessagePayload {
  private OffsetDateTime validFrom;

  private OffsetDateTime validUntil;

  private OffsetDateTime previousValidFrom;

  private OffsetDateTime previousValidUntil;

  private String type;

  public StandalonePriceValidFromAndUntilSet() {
  }

  public StandalonePriceValidFromAndUntilSet(OffsetDateTime validFrom, OffsetDateTime validUntil,
      OffsetDateTime previousValidFrom, OffsetDateTime previousValidUntil, String type) {
    this.validFrom = validFrom;
    this.validUntil = validUntil;
    this.previousValidFrom = previousValidFrom;
    this.previousValidUntil = previousValidUntil;
    this.type = type;
  }

  public OffsetDateTime getValidFrom() {
    return validFrom;
  }

  public void setValidFrom(OffsetDateTime validFrom) {
    this.validFrom = validFrom;
  }

  public OffsetDateTime getValidUntil() {
    return validUntil;
  }

  public void setValidUntil(OffsetDateTime validUntil) {
    this.validUntil = validUntil;
  }

  public OffsetDateTime getPreviousValidFrom() {
    return previousValidFrom;
  }

  public void setPreviousValidFrom(OffsetDateTime previousValidFrom) {
    this.previousValidFrom = previousValidFrom;
  }

  public OffsetDateTime getPreviousValidUntil() {
    return previousValidUntil;
  }

  public void setPreviousValidUntil(OffsetDateTime previousValidUntil) {
    this.previousValidUntil = previousValidUntil;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "StandalonePriceValidFromAndUntilSet{validFrom='" + validFrom + "', validUntil='" + validUntil + "', previousValidFrom='" + previousValidFrom + "', previousValidUntil='" + previousValidUntil + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    StandalonePriceValidFromAndUntilSet that = (StandalonePriceValidFromAndUntilSet) o;
    return Objects.equals(validFrom, that.validFrom) &&
        Objects.equals(validUntil, that.validUntil) &&
        Objects.equals(previousValidFrom, that.previousValidFrom) &&
        Objects.equals(previousValidUntil, that.previousValidUntil) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(validFrom, validUntil, previousValidFrom, previousValidUntil, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private OffsetDateTime validFrom;

    private OffsetDateTime validUntil;

    private OffsetDateTime previousValidFrom;

    private OffsetDateTime previousValidUntil;

    private String type;

    public StandalonePriceValidFromAndUntilSet build() {
      StandalonePriceValidFromAndUntilSet result = new StandalonePriceValidFromAndUntilSet();
      result.validFrom = this.validFrom;
      result.validUntil = this.validUntil;
      result.previousValidFrom = this.previousValidFrom;
      result.previousValidUntil = this.previousValidUntil;
      result.type = this.type;
      return result;
    }

    public Builder validFrom(OffsetDateTime validFrom) {
      this.validFrom = validFrom;
      return this;
    }

    public Builder validUntil(OffsetDateTime validUntil) {
      this.validUntil = validUntil;
      return this;
    }

    public Builder previousValidFrom(OffsetDateTime previousValidFrom) {
      this.previousValidFrom = previousValidFrom;
      return this;
    }

    public Builder previousValidUntil(OffsetDateTime previousValidUntil) {
      this.previousValidUntil = previousValidUntil;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
