package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.time.OffsetDateTime;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class StandalonePriceValidUntilSet implements com.commercetools.graphql.api.types.MessagePayload {
  private OffsetDateTime validUntil;

  private OffsetDateTime previousValidUntil;

  private String type;

  public StandalonePriceValidUntilSet() {
  }

  public StandalonePriceValidUntilSet(OffsetDateTime validUntil, OffsetDateTime previousValidUntil,
      String type) {
    this.validUntil = validUntil;
    this.previousValidUntil = previousValidUntil;
    this.type = type;
  }

  public OffsetDateTime getValidUntil() {
    return validUntil;
  }

  public void setValidUntil(OffsetDateTime validUntil) {
    this.validUntil = validUntil;
  }

  public OffsetDateTime getPreviousValidUntil() {
    return previousValidUntil;
  }

  public void setPreviousValidUntil(OffsetDateTime previousValidUntil) {
    this.previousValidUntil = previousValidUntil;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "StandalonePriceValidUntilSet{validUntil='" + validUntil + "', previousValidUntil='" + previousValidUntil + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    StandalonePriceValidUntilSet that = (StandalonePriceValidUntilSet) o;
    return Objects.equals(validUntil, that.validUntil) &&
        Objects.equals(previousValidUntil, that.previousValidUntil) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(validUntil, previousValidUntil, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private OffsetDateTime validUntil;

    private OffsetDateTime previousValidUntil;

    private String type;

    public StandalonePriceValidUntilSet build() {
      StandalonePriceValidUntilSet result = new StandalonePriceValidUntilSet();
      result.validUntil = this.validUntil;
      result.previousValidUntil = this.previousValidUntil;
      result.type = this.type;
      return result;
    }

    public Builder validUntil(OffsetDateTime validUntil) {
      this.validUntil = validUntil;
      return this;
    }

    public Builder previousValidUntil(OffsetDateTime previousValidUntil) {
      this.previousValidUntil = previousValidUntil;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
