package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class StandalonePriceValueChanged implements com.commercetools.graphql.api.types.MessagePayload {
  private BaseMoney value;

  private Boolean staged;

  private BaseMoney oldValue;

  private String type;

  public StandalonePriceValueChanged() {
  }

  public StandalonePriceValueChanged(BaseMoney value, Boolean staged, BaseMoney oldValue,
      String type) {
    this.value = value;
    this.staged = staged;
    this.oldValue = oldValue;
    this.type = type;
  }

  public BaseMoney getValue() {
    return value;
  }

  public void setValue(BaseMoney value) {
    this.value = value;
  }

  public Boolean getStaged() {
    return staged;
  }

  public void setStaged(Boolean staged) {
    this.staged = staged;
  }

  public BaseMoney getOldValue() {
    return oldValue;
  }

  public void setOldValue(BaseMoney oldValue) {
    this.oldValue = oldValue;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "StandalonePriceValueChanged{value='" + value + "', staged='" + staged + "', oldValue='" + oldValue + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    StandalonePriceValueChanged that = (StandalonePriceValueChanged) o;
    return Objects.equals(value, that.value) &&
        Objects.equals(staged, that.staged) &&
        Objects.equals(oldValue, that.oldValue) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(value, staged, oldValue, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private BaseMoney value;

    private Boolean staged;

    private BaseMoney oldValue;

    private String type;

    public StandalonePriceValueChanged build() {
      StandalonePriceValueChanged result = new StandalonePriceValueChanged();
      result.value = this.value;
      result.staged = this.staged;
      result.oldValue = this.oldValue;
      result.type = this.type;
      return result;
    }

    public Builder value(BaseMoney value) {
      this.value = value;
      return this;
    }

    public Builder staged(Boolean staged) {
      this.staged = staged;
      return this;
    }

    public Builder oldValue(BaseMoney oldValue) {
      this.oldValue = oldValue;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
