package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Boolean;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Objects;

/**
 * [State](https://docs.commercetools.com/api/projects/states)
 */
@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class State implements com.commercetools.graphql.api.types.Versioned, com.commercetools.graphql.api.types.ReferenceExpandable {
  private String id;

  private Long version;

  private String key;

  private StateType type;

  private List<StateRole> roles;

  private String name;

  private List<LocalizedString> nameAllLocales;

  private String description;

  private List<LocalizedString> descriptionAllLocales;

  private Boolean builtIn;

  private List<Reference> transitionsRef;

  private List<State> transitions;

  private Boolean initial;

  private OffsetDateTime createdAt;

  private OffsetDateTime lastModifiedAt;

  private Initiator createdBy;

  private Initiator lastModifiedBy;

  public State() {
  }

  public State(String id, Long version, String key, StateType type, List<StateRole> roles,
      String name, List<LocalizedString> nameAllLocales, String description,
      List<LocalizedString> descriptionAllLocales, Boolean builtIn, List<Reference> transitionsRef,
      List<State> transitions, Boolean initial, OffsetDateTime createdAt,
      OffsetDateTime lastModifiedAt, Initiator createdBy, Initiator lastModifiedBy) {
    this.id = id;
    this.version = version;
    this.key = key;
    this.type = type;
    this.roles = roles;
    this.name = name;
    this.nameAllLocales = nameAllLocales;
    this.description = description;
    this.descriptionAllLocales = descriptionAllLocales;
    this.builtIn = builtIn;
    this.transitionsRef = transitionsRef;
    this.transitions = transitions;
    this.initial = initial;
    this.createdAt = createdAt;
    this.lastModifiedAt = lastModifiedAt;
    this.createdBy = createdBy;
    this.lastModifiedBy = lastModifiedBy;
  }

  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }

  public Long getVersion() {
    return version;
  }

  public void setVersion(Long version) {
    this.version = version;
  }

  public String getKey() {
    return key;
  }

  public void setKey(String key) {
    this.key = key;
  }

  public StateType getType() {
    return type;
  }

  public void setType(StateType type) {
    this.type = type;
  }

  public List<StateRole> getRoles() {
    return roles;
  }

  public void setRoles(List<StateRole> roles) {
    this.roles = roles;
  }

  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public List<LocalizedString> getNameAllLocales() {
    return nameAllLocales;
  }

  public void setNameAllLocales(List<LocalizedString> nameAllLocales) {
    this.nameAllLocales = nameAllLocales;
  }

  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }

  public List<LocalizedString> getDescriptionAllLocales() {
    return descriptionAllLocales;
  }

  public void setDescriptionAllLocales(List<LocalizedString> descriptionAllLocales) {
    this.descriptionAllLocales = descriptionAllLocales;
  }

  public Boolean getBuiltIn() {
    return builtIn;
  }

  public void setBuiltIn(Boolean builtIn) {
    this.builtIn = builtIn;
  }

  public List<Reference> getTransitionsRef() {
    return transitionsRef;
  }

  public void setTransitionsRef(List<Reference> transitionsRef) {
    this.transitionsRef = transitionsRef;
  }

  public List<State> getTransitions() {
    return transitions;
  }

  public void setTransitions(List<State> transitions) {
    this.transitions = transitions;
  }

  public Boolean getInitial() {
    return initial;
  }

  public void setInitial(Boolean initial) {
    this.initial = initial;
  }

  public OffsetDateTime getCreatedAt() {
    return createdAt;
  }

  public void setCreatedAt(OffsetDateTime createdAt) {
    this.createdAt = createdAt;
  }

  public OffsetDateTime getLastModifiedAt() {
    return lastModifiedAt;
  }

  public void setLastModifiedAt(OffsetDateTime lastModifiedAt) {
    this.lastModifiedAt = lastModifiedAt;
  }

  public Initiator getCreatedBy() {
    return createdBy;
  }

  public void setCreatedBy(Initiator createdBy) {
    this.createdBy = createdBy;
  }

  public Initiator getLastModifiedBy() {
    return lastModifiedBy;
  }

  public void setLastModifiedBy(Initiator lastModifiedBy) {
    this.lastModifiedBy = lastModifiedBy;
  }

  @Override
  public String toString() {
    return "State{id='" + id + "', version='" + version + "', key='" + key + "', type='" + type + "', roles='" + roles + "', name='" + name + "', nameAllLocales='" + nameAllLocales + "', description='" + description + "', descriptionAllLocales='" + descriptionAllLocales + "', builtIn='" + builtIn + "', transitionsRef='" + transitionsRef + "', transitions='" + transitions + "', initial='" + initial + "', createdAt='" + createdAt + "', lastModifiedAt='" + lastModifiedAt + "', createdBy='" + createdBy + "', lastModifiedBy='" + lastModifiedBy + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    State that = (State) o;
    return Objects.equals(id, that.id) &&
        Objects.equals(version, that.version) &&
        Objects.equals(key, that.key) &&
        Objects.equals(type, that.type) &&
        Objects.equals(roles, that.roles) &&
        Objects.equals(name, that.name) &&
        Objects.equals(nameAllLocales, that.nameAllLocales) &&
        Objects.equals(description, that.description) &&
        Objects.equals(descriptionAllLocales, that.descriptionAllLocales) &&
        Objects.equals(builtIn, that.builtIn) &&
        Objects.equals(transitionsRef, that.transitionsRef) &&
        Objects.equals(transitions, that.transitions) &&
        Objects.equals(initial, that.initial) &&
        Objects.equals(createdAt, that.createdAt) &&
        Objects.equals(lastModifiedAt, that.lastModifiedAt) &&
        Objects.equals(createdBy, that.createdBy) &&
        Objects.equals(lastModifiedBy, that.lastModifiedBy);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, version, key, type, roles, name, nameAllLocales, description, descriptionAllLocales, builtIn, transitionsRef, transitions, initial, createdAt, lastModifiedAt, createdBy, lastModifiedBy);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String id;

    private Long version;

    private String key;

    private StateType type;

    private List<StateRole> roles;

    private String name;

    private List<LocalizedString> nameAllLocales;

    private String description;

    private List<LocalizedString> descriptionAllLocales;

    private Boolean builtIn;

    private List<Reference> transitionsRef;

    private List<State> transitions;

    private Boolean initial;

    private OffsetDateTime createdAt;

    private OffsetDateTime lastModifiedAt;

    private Initiator createdBy;

    private Initiator lastModifiedBy;

    public State build() {
      State result = new State();
      result.id = this.id;
      result.version = this.version;
      result.key = this.key;
      result.type = this.type;
      result.roles = this.roles;
      result.name = this.name;
      result.nameAllLocales = this.nameAllLocales;
      result.description = this.description;
      result.descriptionAllLocales = this.descriptionAllLocales;
      result.builtIn = this.builtIn;
      result.transitionsRef = this.transitionsRef;
      result.transitions = this.transitions;
      result.initial = this.initial;
      result.createdAt = this.createdAt;
      result.lastModifiedAt = this.lastModifiedAt;
      result.createdBy = this.createdBy;
      result.lastModifiedBy = this.lastModifiedBy;
      return result;
    }

    public Builder id(String id) {
      this.id = id;
      return this;
    }

    public Builder version(Long version) {
      this.version = version;
      return this;
    }

    public Builder key(String key) {
      this.key = key;
      return this;
    }

    public Builder type(StateType type) {
      this.type = type;
      return this;
    }

    public Builder roles(List<StateRole> roles) {
      this.roles = roles;
      return this;
    }

    public Builder name(String name) {
      this.name = name;
      return this;
    }

    public Builder nameAllLocales(List<LocalizedString> nameAllLocales) {
      this.nameAllLocales = nameAllLocales;
      return this;
    }

    public Builder description(String description) {
      this.description = description;
      return this;
    }

    public Builder descriptionAllLocales(List<LocalizedString> descriptionAllLocales) {
      this.descriptionAllLocales = descriptionAllLocales;
      return this;
    }

    public Builder builtIn(Boolean builtIn) {
      this.builtIn = builtIn;
      return this;
    }

    public Builder transitionsRef(List<Reference> transitionsRef) {
      this.transitionsRef = transitionsRef;
      return this;
    }

    public Builder transitions(List<State> transitions) {
      this.transitions = transitions;
      return this;
    }

    public Builder initial(Boolean initial) {
      this.initial = initial;
      return this;
    }

    public Builder createdAt(OffsetDateTime createdAt) {
      this.createdAt = createdAt;
      return this;
    }

    public Builder lastModifiedAt(OffsetDateTime lastModifiedAt) {
      this.lastModifiedAt = lastModifiedAt;
      return this;
    }

    public Builder createdBy(Initiator createdBy) {
      this.createdBy = createdBy;
      return this;
    }

    public Builder lastModifiedBy(Initiator lastModifiedBy) {
      this.lastModifiedBy = lastModifiedBy;
      return this;
    }
  }
}
