package com.commercetools.graphql.api.types;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

public class StateDraft {
  private String key;

  private StateType type;

  private List<LocalizedStringItemInputType> name;

  private List<LocalizedStringItemInputType> description;

  private Boolean initial;

  private List<StateRole> roles;

  private List<ReferenceInput> transitions;

  public StateDraft() {
  }

  public StateDraft(String key, StateType type, List<LocalizedStringItemInputType> name,
      List<LocalizedStringItemInputType> description, Boolean initial, List<StateRole> roles,
      List<ReferenceInput> transitions) {
    this.key = key;
    this.type = type;
    this.name = name;
    this.description = description;
    this.initial = initial;
    this.roles = roles;
    this.transitions = transitions;
  }

  public String getKey() {
    return key;
  }

  public void setKey(String key) {
    this.key = key;
  }

  public StateType getType() {
    return type;
  }

  public void setType(StateType type) {
    this.type = type;
  }

  public List<LocalizedStringItemInputType> getName() {
    return name;
  }

  public void setName(List<LocalizedStringItemInputType> name) {
    this.name = name;
  }

  public List<LocalizedStringItemInputType> getDescription() {
    return description;
  }

  public void setDescription(List<LocalizedStringItemInputType> description) {
    this.description = description;
  }

  public Boolean getInitial() {
    return initial;
  }

  public void setInitial(Boolean initial) {
    this.initial = initial;
  }

  public List<StateRole> getRoles() {
    return roles;
  }

  public void setRoles(List<StateRole> roles) {
    this.roles = roles;
  }

  public List<ReferenceInput> getTransitions() {
    return transitions;
  }

  public void setTransitions(List<ReferenceInput> transitions) {
    this.transitions = transitions;
  }

  @Override
  public String toString() {
    return "StateDraft{key='" + key + "', type='" + type + "', name='" + name + "', description='" + description + "', initial='" + initial + "', roles='" + roles + "', transitions='" + transitions + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    StateDraft that = (StateDraft) o;
    return Objects.equals(key, that.key) &&
        Objects.equals(type, that.type) &&
        Objects.equals(name, that.name) &&
        Objects.equals(description, that.description) &&
        Objects.equals(initial, that.initial) &&
        Objects.equals(roles, that.roles) &&
        Objects.equals(transitions, that.transitions);
  }

  @Override
  public int hashCode() {
    return Objects.hash(key, type, name, description, initial, roles, transitions);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String key;

    private StateType type;

    private List<LocalizedStringItemInputType> name;

    private List<LocalizedStringItemInputType> description;

    private Boolean initial;

    private List<StateRole> roles;

    private List<ReferenceInput> transitions;

    public StateDraft build() {
      StateDraft result = new StateDraft();
      result.key = this.key;
      result.type = this.type;
      result.name = this.name;
      result.description = this.description;
      result.initial = this.initial;
      result.roles = this.roles;
      result.transitions = this.transitions;
      return result;
    }

    public Builder key(String key) {
      this.key = key;
      return this;
    }

    public Builder type(StateType type) {
      this.type = type;
      return this;
    }

    public Builder name(List<LocalizedStringItemInputType> name) {
      this.name = name;
      return this;
    }

    public Builder description(List<LocalizedStringItemInputType> description) {
      this.description = description;
      return this;
    }

    public Builder initial(Boolean initial) {
      this.initial = initial;
      return this;
    }

    public Builder roles(List<StateRole> roles) {
      this.roles = roles;
      return this;
    }

    public Builder transitions(List<ReferenceInput> transitions) {
      this.transitions = transitions;
      return this;
    }
  }
}
