package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class StateUpdateAction {
  private AddStateRoles addRoles;

  private ChangeStateInitial changeInitial;

  private ChangeStateKey changeKey;

  private ChangeStateType changeType;

  private RemoveStateRoles removeRoles;

  private SetStateDescription setDescription;

  private SetStateName setName;

  private SetStateRoles setRoles;

  private SetStateTransitions setTransitions;

  public StateUpdateAction() {
  }

  public StateUpdateAction(AddStateRoles addRoles, ChangeStateInitial changeInitial,
      ChangeStateKey changeKey, ChangeStateType changeType, RemoveStateRoles removeRoles,
      SetStateDescription setDescription, SetStateName setName, SetStateRoles setRoles,
      SetStateTransitions setTransitions) {
    this.addRoles = addRoles;
    this.changeInitial = changeInitial;
    this.changeKey = changeKey;
    this.changeType = changeType;
    this.removeRoles = removeRoles;
    this.setDescription = setDescription;
    this.setName = setName;
    this.setRoles = setRoles;
    this.setTransitions = setTransitions;
  }

  public AddStateRoles getAddRoles() {
    return addRoles;
  }

  public void setAddRoles(AddStateRoles addRoles) {
    this.addRoles = addRoles;
  }

  public ChangeStateInitial getChangeInitial() {
    return changeInitial;
  }

  public void setChangeInitial(ChangeStateInitial changeInitial) {
    this.changeInitial = changeInitial;
  }

  public ChangeStateKey getChangeKey() {
    return changeKey;
  }

  public void setChangeKey(ChangeStateKey changeKey) {
    this.changeKey = changeKey;
  }

  public ChangeStateType getChangeType() {
    return changeType;
  }

  public void setChangeType(ChangeStateType changeType) {
    this.changeType = changeType;
  }

  public RemoveStateRoles getRemoveRoles() {
    return removeRoles;
  }

  public void setRemoveRoles(RemoveStateRoles removeRoles) {
    this.removeRoles = removeRoles;
  }

  public SetStateDescription getSetDescription() {
    return setDescription;
  }

  public void setSetDescription(SetStateDescription setDescription) {
    this.setDescription = setDescription;
  }

  public SetStateName getSetName() {
    return setName;
  }

  public void setSetName(SetStateName setName) {
    this.setName = setName;
  }

  public SetStateRoles getSetRoles() {
    return setRoles;
  }

  public void setSetRoles(SetStateRoles setRoles) {
    this.setRoles = setRoles;
  }

  public SetStateTransitions getSetTransitions() {
    return setTransitions;
  }

  public void setSetTransitions(SetStateTransitions setTransitions) {
    this.setTransitions = setTransitions;
  }

  @Override
  public String toString() {
    return "StateUpdateAction{addRoles='" + addRoles + "', changeInitial='" + changeInitial + "', changeKey='" + changeKey + "', changeType='" + changeType + "', removeRoles='" + removeRoles + "', setDescription='" + setDescription + "', setName='" + setName + "', setRoles='" + setRoles + "', setTransitions='" + setTransitions + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    StateUpdateAction that = (StateUpdateAction) o;
    return Objects.equals(addRoles, that.addRoles) &&
        Objects.equals(changeInitial, that.changeInitial) &&
        Objects.equals(changeKey, that.changeKey) &&
        Objects.equals(changeType, that.changeType) &&
        Objects.equals(removeRoles, that.removeRoles) &&
        Objects.equals(setDescription, that.setDescription) &&
        Objects.equals(setName, that.setName) &&
        Objects.equals(setRoles, that.setRoles) &&
        Objects.equals(setTransitions, that.setTransitions);
  }

  @Override
  public int hashCode() {
    return Objects.hash(addRoles, changeInitial, changeKey, changeType, removeRoles, setDescription, setName, setRoles, setTransitions);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private AddStateRoles addRoles;

    private ChangeStateInitial changeInitial;

    private ChangeStateKey changeKey;

    private ChangeStateType changeType;

    private RemoveStateRoles removeRoles;

    private SetStateDescription setDescription;

    private SetStateName setName;

    private SetStateRoles setRoles;

    private SetStateTransitions setTransitions;

    public StateUpdateAction build() {
      StateUpdateAction result = new StateUpdateAction();
      result.addRoles = this.addRoles;
      result.changeInitial = this.changeInitial;
      result.changeKey = this.changeKey;
      result.changeType = this.changeType;
      result.removeRoles = this.removeRoles;
      result.setDescription = this.setDescription;
      result.setName = this.setName;
      result.setRoles = this.setRoles;
      result.setTransitions = this.setTransitions;
      return result;
    }

    public Builder addRoles(AddStateRoles addRoles) {
      this.addRoles = addRoles;
      return this;
    }

    public Builder changeInitial(ChangeStateInitial changeInitial) {
      this.changeInitial = changeInitial;
      return this;
    }

    public Builder changeKey(ChangeStateKey changeKey) {
      this.changeKey = changeKey;
      return this;
    }

    public Builder changeType(ChangeStateType changeType) {
      this.changeType = changeType;
      return this;
    }

    public Builder removeRoles(RemoveStateRoles removeRoles) {
      this.removeRoles = removeRoles;
      return this;
    }

    public Builder setDescription(SetStateDescription setDescription) {
      this.setDescription = setDescription;
      return this;
    }

    public Builder setName(SetStateName setName) {
      this.setName = setName;
      return this;
    }

    public Builder setRoles(SetStateRoles setRoles) {
      this.setRoles = setRoles;
      return this;
    }

    public Builder setTransitions(SetStateTransitions setTransitions) {
      this.setTransitions = setTransitions;
      return this;
    }
  }
}
