package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class StoreCountriesChanged implements com.commercetools.graphql.api.types.MessagePayload {
  private List<StoreCountry> addedCountries;

  private List<StoreCountry> removedCountries;

  private String type;

  public StoreCountriesChanged() {
  }

  public StoreCountriesChanged(List<StoreCountry> addedCountries,
      List<StoreCountry> removedCountries, String type) {
    this.addedCountries = addedCountries;
    this.removedCountries = removedCountries;
    this.type = type;
  }

  public List<StoreCountry> getAddedCountries() {
    return addedCountries;
  }

  public void setAddedCountries(List<StoreCountry> addedCountries) {
    this.addedCountries = addedCountries;
  }

  public List<StoreCountry> getRemovedCountries() {
    return removedCountries;
  }

  public void setRemovedCountries(List<StoreCountry> removedCountries) {
    this.removedCountries = removedCountries;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "StoreCountriesChanged{addedCountries='" + addedCountries + "', removedCountries='" + removedCountries + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    StoreCountriesChanged that = (StoreCountriesChanged) o;
    return Objects.equals(addedCountries, that.addedCountries) &&
        Objects.equals(removedCountries, that.removedCountries) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(addedCountries, removedCountries, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private List<StoreCountry> addedCountries;

    private List<StoreCountry> removedCountries;

    private String type;

    public StoreCountriesChanged build() {
      StoreCountriesChanged result = new StoreCountriesChanged();
      result.addedCountries = this.addedCountries;
      result.removedCountries = this.removedCountries;
      result.type = this.type;
      return result;
    }

    public Builder addedCountries(List<StoreCountry> addedCountries) {
      this.addedCountries = addedCountries;
      return this;
    }

    public Builder removedCountries(List<StoreCountry> removedCountries) {
      this.removedCountries = removedCountries;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
