package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class StoreDistributionChannelsChanged implements com.commercetools.graphql.api.types.MessagePayload {
  private List<Channel> addedDistributionChannels;

  private List<Channel> removedDistributionChannels;

  private List<Reference> addedDistributionChannelsRef;

  private List<Reference> removedDistributionChannelsRef;

  private String type;

  public StoreDistributionChannelsChanged() {
  }

  public StoreDistributionChannelsChanged(List<Channel> addedDistributionChannels,
      List<Channel> removedDistributionChannels, List<Reference> addedDistributionChannelsRef,
      List<Reference> removedDistributionChannelsRef, String type) {
    this.addedDistributionChannels = addedDistributionChannels;
    this.removedDistributionChannels = removedDistributionChannels;
    this.addedDistributionChannelsRef = addedDistributionChannelsRef;
    this.removedDistributionChannelsRef = removedDistributionChannelsRef;
    this.type = type;
  }

  public List<Channel> getAddedDistributionChannels() {
    return addedDistributionChannels;
  }

  public void setAddedDistributionChannels(List<Channel> addedDistributionChannels) {
    this.addedDistributionChannels = addedDistributionChannels;
  }

  public List<Channel> getRemovedDistributionChannels() {
    return removedDistributionChannels;
  }

  public void setRemovedDistributionChannels(List<Channel> removedDistributionChannels) {
    this.removedDistributionChannels = removedDistributionChannels;
  }

  public List<Reference> getAddedDistributionChannelsRef() {
    return addedDistributionChannelsRef;
  }

  public void setAddedDistributionChannelsRef(List<Reference> addedDistributionChannelsRef) {
    this.addedDistributionChannelsRef = addedDistributionChannelsRef;
  }

  public List<Reference> getRemovedDistributionChannelsRef() {
    return removedDistributionChannelsRef;
  }

  public void setRemovedDistributionChannelsRef(List<Reference> removedDistributionChannelsRef) {
    this.removedDistributionChannelsRef = removedDistributionChannelsRef;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "StoreDistributionChannelsChanged{addedDistributionChannels='" + addedDistributionChannels + "', removedDistributionChannels='" + removedDistributionChannels + "', addedDistributionChannelsRef='" + addedDistributionChannelsRef + "', removedDistributionChannelsRef='" + removedDistributionChannelsRef + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    StoreDistributionChannelsChanged that = (StoreDistributionChannelsChanged) o;
    return Objects.equals(addedDistributionChannels, that.addedDistributionChannels) &&
        Objects.equals(removedDistributionChannels, that.removedDistributionChannels) &&
        Objects.equals(addedDistributionChannelsRef, that.addedDistributionChannelsRef) &&
        Objects.equals(removedDistributionChannelsRef, that.removedDistributionChannelsRef) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(addedDistributionChannels, removedDistributionChannels, addedDistributionChannelsRef, removedDistributionChannelsRef, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private List<Channel> addedDistributionChannels;

    private List<Channel> removedDistributionChannels;

    private List<Reference> addedDistributionChannelsRef;

    private List<Reference> removedDistributionChannelsRef;

    private String type;

    public StoreDistributionChannelsChanged build() {
      StoreDistributionChannelsChanged result = new StoreDistributionChannelsChanged();
      result.addedDistributionChannels = this.addedDistributionChannels;
      result.removedDistributionChannels = this.removedDistributionChannels;
      result.addedDistributionChannelsRef = this.addedDistributionChannelsRef;
      result.removedDistributionChannelsRef = this.removedDistributionChannelsRef;
      result.type = this.type;
      return result;
    }

    public Builder addedDistributionChannels(List<Channel> addedDistributionChannels) {
      this.addedDistributionChannels = addedDistributionChannels;
      return this;
    }

    public Builder removedDistributionChannels(List<Channel> removedDistributionChannels) {
      this.removedDistributionChannels = removedDistributionChannels;
      return this;
    }

    public Builder addedDistributionChannelsRef(List<Reference> addedDistributionChannelsRef) {
      this.addedDistributionChannelsRef = addedDistributionChannelsRef;
      return this;
    }

    public Builder removedDistributionChannelsRef(List<Reference> removedDistributionChannelsRef) {
      this.removedDistributionChannelsRef = removedDistributionChannelsRef;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
