package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class StoreLanguagesChanged implements com.commercetools.graphql.api.types.MessagePayload {
  private List<String> addedLanguages;

  private List<String> removedLanguages;

  private String type;

  public StoreLanguagesChanged() {
  }

  public StoreLanguagesChanged(List<String> addedLanguages, List<String> removedLanguages,
      String type) {
    this.addedLanguages = addedLanguages;
    this.removedLanguages = removedLanguages;
    this.type = type;
  }

  public List<String> getAddedLanguages() {
    return addedLanguages;
  }

  public void setAddedLanguages(List<String> addedLanguages) {
    this.addedLanguages = addedLanguages;
  }

  public List<String> getRemovedLanguages() {
    return removedLanguages;
  }

  public void setRemovedLanguages(List<String> removedLanguages) {
    this.removedLanguages = removedLanguages;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "StoreLanguagesChanged{addedLanguages='" + addedLanguages + "', removedLanguages='" + removedLanguages + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    StoreLanguagesChanged that = (StoreLanguagesChanged) o;
    return Objects.equals(addedLanguages, that.addedLanguages) &&
        Objects.equals(removedLanguages, that.removedLanguages) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(addedLanguages, removedLanguages, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private List<String> addedLanguages;

    private List<String> removedLanguages;

    private String type;

    public StoreLanguagesChanged build() {
      StoreLanguagesChanged result = new StoreLanguagesChanged();
      result.addedLanguages = this.addedLanguages;
      result.removedLanguages = this.removedLanguages;
      result.type = this.type;
      return result;
    }

    public Builder addedLanguages(List<String> addedLanguages) {
      this.addedLanguages = addedLanguages;
      return this;
    }

    public Builder removedLanguages(List<String> removedLanguages) {
      this.removedLanguages = removedLanguages;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
