package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class StoreLimitsProjection {
  private Limit productSelections;

  private Limit inventorySupplyChannels;

  private Limit productDistributionChannels;

  private StoreLimitWithCurrent total;

  public StoreLimitsProjection() {
  }

  public StoreLimitsProjection(Limit productSelections, Limit inventorySupplyChannels,
      Limit productDistributionChannels, StoreLimitWithCurrent total) {
    this.productSelections = productSelections;
    this.inventorySupplyChannels = inventorySupplyChannels;
    this.productDistributionChannels = productDistributionChannels;
    this.total = total;
  }

  public Limit getProductSelections() {
    return productSelections;
  }

  public void setProductSelections(Limit productSelections) {
    this.productSelections = productSelections;
  }

  public Limit getInventorySupplyChannels() {
    return inventorySupplyChannels;
  }

  public void setInventorySupplyChannels(Limit inventorySupplyChannels) {
    this.inventorySupplyChannels = inventorySupplyChannels;
  }

  public Limit getProductDistributionChannels() {
    return productDistributionChannels;
  }

  public void setProductDistributionChannels(Limit productDistributionChannels) {
    this.productDistributionChannels = productDistributionChannels;
  }

  public StoreLimitWithCurrent getTotal() {
    return total;
  }

  public void setTotal(StoreLimitWithCurrent total) {
    this.total = total;
  }

  @Override
  public String toString() {
    return "StoreLimitsProjection{productSelections='" + productSelections + "', inventorySupplyChannels='" + inventorySupplyChannels + "', productDistributionChannels='" + productDistributionChannels + "', total='" + total + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    StoreLimitsProjection that = (StoreLimitsProjection) o;
    return Objects.equals(productSelections, that.productSelections) &&
        Objects.equals(inventorySupplyChannels, that.inventorySupplyChannels) &&
        Objects.equals(productDistributionChannels, that.productDistributionChannels) &&
        Objects.equals(total, that.total);
  }

  @Override
  public int hashCode() {
    return Objects.hash(productSelections, inventorySupplyChannels, productDistributionChannels, total);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private Limit productSelections;

    private Limit inventorySupplyChannels;

    private Limit productDistributionChannels;

    private StoreLimitWithCurrent total;

    public StoreLimitsProjection build() {
      StoreLimitsProjection result = new StoreLimitsProjection();
      result.productSelections = this.productSelections;
      result.inventorySupplyChannels = this.inventorySupplyChannels;
      result.productDistributionChannels = this.productDistributionChannels;
      result.total = this.total;
      return result;
    }

    public Builder productSelections(Limit productSelections) {
      this.productSelections = productSelections;
      return this;
    }

    public Builder inventorySupplyChannels(Limit inventorySupplyChannels) {
      this.inventorySupplyChannels = inventorySupplyChannels;
      return this;
    }

    public Builder productDistributionChannels(Limit productDistributionChannels) {
      this.productDistributionChannels = productDistributionChannels;
      return this;
    }

    public Builder total(StoreLimitWithCurrent total) {
      this.total = total;
      return this;
    }
  }
}
