package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class StoreUpdateAction {
  private AddStoreProductSelection addProductSelection;

  private AddStoreCountry addCountry;

  private AddStoreDistributionChannel addDistributionChannel;

  private AddStoreSupplyChannel addSupplyChannel;

  private ChangeStoreProductSelectionActive changeProductSelectionActive;

  private RemoveStoreProductSelection removeProductSelection;

  private RemoveStoreCountry removeCountry;

  private RemoveStoreDistributionChannel removeDistributionChannel;

  private RemoveStoreSupplyChannel removeSupplyChannel;

  private SetStoreProductSelections setProductSelections;

  private SetStoreCountries setCountries;

  private SetStoreCustomField setCustomField;

  private SetStoreCustomType setCustomType;

  private SetStoreDistributionChannels setDistributionChannels;

  private SetStoreLanguages setLanguages;

  private SetStoreName setName;

  private SetStoreSupplyChannels setSupplyChannels;

  public StoreUpdateAction() {
  }

  public StoreUpdateAction(AddStoreProductSelection addProductSelection, AddStoreCountry addCountry,
      AddStoreDistributionChannel addDistributionChannel, AddStoreSupplyChannel addSupplyChannel,
      ChangeStoreProductSelectionActive changeProductSelectionActive,
      RemoveStoreProductSelection removeProductSelection, RemoveStoreCountry removeCountry,
      RemoveStoreDistributionChannel removeDistributionChannel,
      RemoveStoreSupplyChannel removeSupplyChannel, SetStoreProductSelections setProductSelections,
      SetStoreCountries setCountries, SetStoreCustomField setCustomField,
      SetStoreCustomType setCustomType, SetStoreDistributionChannels setDistributionChannels,
      SetStoreLanguages setLanguages, SetStoreName setName,
      SetStoreSupplyChannels setSupplyChannels) {
    this.addProductSelection = addProductSelection;
    this.addCountry = addCountry;
    this.addDistributionChannel = addDistributionChannel;
    this.addSupplyChannel = addSupplyChannel;
    this.changeProductSelectionActive = changeProductSelectionActive;
    this.removeProductSelection = removeProductSelection;
    this.removeCountry = removeCountry;
    this.removeDistributionChannel = removeDistributionChannel;
    this.removeSupplyChannel = removeSupplyChannel;
    this.setProductSelections = setProductSelections;
    this.setCountries = setCountries;
    this.setCustomField = setCustomField;
    this.setCustomType = setCustomType;
    this.setDistributionChannels = setDistributionChannels;
    this.setLanguages = setLanguages;
    this.setName = setName;
    this.setSupplyChannels = setSupplyChannels;
  }

  public AddStoreProductSelection getAddProductSelection() {
    return addProductSelection;
  }

  public void setAddProductSelection(AddStoreProductSelection addProductSelection) {
    this.addProductSelection = addProductSelection;
  }

  public AddStoreCountry getAddCountry() {
    return addCountry;
  }

  public void setAddCountry(AddStoreCountry addCountry) {
    this.addCountry = addCountry;
  }

  public AddStoreDistributionChannel getAddDistributionChannel() {
    return addDistributionChannel;
  }

  public void setAddDistributionChannel(AddStoreDistributionChannel addDistributionChannel) {
    this.addDistributionChannel = addDistributionChannel;
  }

  public AddStoreSupplyChannel getAddSupplyChannel() {
    return addSupplyChannel;
  }

  public void setAddSupplyChannel(AddStoreSupplyChannel addSupplyChannel) {
    this.addSupplyChannel = addSupplyChannel;
  }

  public ChangeStoreProductSelectionActive getChangeProductSelectionActive() {
    return changeProductSelectionActive;
  }

  public void setChangeProductSelectionActive(
      ChangeStoreProductSelectionActive changeProductSelectionActive) {
    this.changeProductSelectionActive = changeProductSelectionActive;
  }

  public RemoveStoreProductSelection getRemoveProductSelection() {
    return removeProductSelection;
  }

  public void setRemoveProductSelection(RemoveStoreProductSelection removeProductSelection) {
    this.removeProductSelection = removeProductSelection;
  }

  public RemoveStoreCountry getRemoveCountry() {
    return removeCountry;
  }

  public void setRemoveCountry(RemoveStoreCountry removeCountry) {
    this.removeCountry = removeCountry;
  }

  public RemoveStoreDistributionChannel getRemoveDistributionChannel() {
    return removeDistributionChannel;
  }

  public void setRemoveDistributionChannel(
      RemoveStoreDistributionChannel removeDistributionChannel) {
    this.removeDistributionChannel = removeDistributionChannel;
  }

  public RemoveStoreSupplyChannel getRemoveSupplyChannel() {
    return removeSupplyChannel;
  }

  public void setRemoveSupplyChannel(RemoveStoreSupplyChannel removeSupplyChannel) {
    this.removeSupplyChannel = removeSupplyChannel;
  }

  public SetStoreProductSelections getSetProductSelections() {
    return setProductSelections;
  }

  public void setSetProductSelections(SetStoreProductSelections setProductSelections) {
    this.setProductSelections = setProductSelections;
  }

  public SetStoreCountries getSetCountries() {
    return setCountries;
  }

  public void setSetCountries(SetStoreCountries setCountries) {
    this.setCountries = setCountries;
  }

  public SetStoreCustomField getSetCustomField() {
    return setCustomField;
  }

  public void setSetCustomField(SetStoreCustomField setCustomField) {
    this.setCustomField = setCustomField;
  }

  public SetStoreCustomType getSetCustomType() {
    return setCustomType;
  }

  public void setSetCustomType(SetStoreCustomType setCustomType) {
    this.setCustomType = setCustomType;
  }

  public SetStoreDistributionChannels getSetDistributionChannels() {
    return setDistributionChannels;
  }

  public void setSetDistributionChannels(SetStoreDistributionChannels setDistributionChannels) {
    this.setDistributionChannels = setDistributionChannels;
  }

  public SetStoreLanguages getSetLanguages() {
    return setLanguages;
  }

  public void setSetLanguages(SetStoreLanguages setLanguages) {
    this.setLanguages = setLanguages;
  }

  public SetStoreName getSetName() {
    return setName;
  }

  public void setSetName(SetStoreName setName) {
    this.setName = setName;
  }

  public SetStoreSupplyChannels getSetSupplyChannels() {
    return setSupplyChannels;
  }

  public void setSetSupplyChannels(SetStoreSupplyChannels setSupplyChannels) {
    this.setSupplyChannels = setSupplyChannels;
  }

  @Override
  public String toString() {
    return "StoreUpdateAction{addProductSelection='" + addProductSelection + "', addCountry='" + addCountry + "', addDistributionChannel='" + addDistributionChannel + "', addSupplyChannel='" + addSupplyChannel + "', changeProductSelectionActive='" + changeProductSelectionActive + "', removeProductSelection='" + removeProductSelection + "', removeCountry='" + removeCountry + "', removeDistributionChannel='" + removeDistributionChannel + "', removeSupplyChannel='" + removeSupplyChannel + "', setProductSelections='" + setProductSelections + "', setCountries='" + setCountries + "', setCustomField='" + setCustomField + "', setCustomType='" + setCustomType + "', setDistributionChannels='" + setDistributionChannels + "', setLanguages='" + setLanguages + "', setName='" + setName + "', setSupplyChannels='" + setSupplyChannels + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    StoreUpdateAction that = (StoreUpdateAction) o;
    return Objects.equals(addProductSelection, that.addProductSelection) &&
        Objects.equals(addCountry, that.addCountry) &&
        Objects.equals(addDistributionChannel, that.addDistributionChannel) &&
        Objects.equals(addSupplyChannel, that.addSupplyChannel) &&
        Objects.equals(changeProductSelectionActive, that.changeProductSelectionActive) &&
        Objects.equals(removeProductSelection, that.removeProductSelection) &&
        Objects.equals(removeCountry, that.removeCountry) &&
        Objects.equals(removeDistributionChannel, that.removeDistributionChannel) &&
        Objects.equals(removeSupplyChannel, that.removeSupplyChannel) &&
        Objects.equals(setProductSelections, that.setProductSelections) &&
        Objects.equals(setCountries, that.setCountries) &&
        Objects.equals(setCustomField, that.setCustomField) &&
        Objects.equals(setCustomType, that.setCustomType) &&
        Objects.equals(setDistributionChannels, that.setDistributionChannels) &&
        Objects.equals(setLanguages, that.setLanguages) &&
        Objects.equals(setName, that.setName) &&
        Objects.equals(setSupplyChannels, that.setSupplyChannels);
  }

  @Override
  public int hashCode() {
    return Objects.hash(addProductSelection, addCountry, addDistributionChannel, addSupplyChannel, changeProductSelectionActive, removeProductSelection, removeCountry, removeDistributionChannel, removeSupplyChannel, setProductSelections, setCountries, setCustomField, setCustomType, setDistributionChannels, setLanguages, setName, setSupplyChannels);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private AddStoreProductSelection addProductSelection;

    private AddStoreCountry addCountry;

    private AddStoreDistributionChannel addDistributionChannel;

    private AddStoreSupplyChannel addSupplyChannel;

    private ChangeStoreProductSelectionActive changeProductSelectionActive;

    private RemoveStoreProductSelection removeProductSelection;

    private RemoveStoreCountry removeCountry;

    private RemoveStoreDistributionChannel removeDistributionChannel;

    private RemoveStoreSupplyChannel removeSupplyChannel;

    private SetStoreProductSelections setProductSelections;

    private SetStoreCountries setCountries;

    private SetStoreCustomField setCustomField;

    private SetStoreCustomType setCustomType;

    private SetStoreDistributionChannels setDistributionChannels;

    private SetStoreLanguages setLanguages;

    private SetStoreName setName;

    private SetStoreSupplyChannels setSupplyChannels;

    public StoreUpdateAction build() {
      StoreUpdateAction result = new StoreUpdateAction();
      result.addProductSelection = this.addProductSelection;
      result.addCountry = this.addCountry;
      result.addDistributionChannel = this.addDistributionChannel;
      result.addSupplyChannel = this.addSupplyChannel;
      result.changeProductSelectionActive = this.changeProductSelectionActive;
      result.removeProductSelection = this.removeProductSelection;
      result.removeCountry = this.removeCountry;
      result.removeDistributionChannel = this.removeDistributionChannel;
      result.removeSupplyChannel = this.removeSupplyChannel;
      result.setProductSelections = this.setProductSelections;
      result.setCountries = this.setCountries;
      result.setCustomField = this.setCustomField;
      result.setCustomType = this.setCustomType;
      result.setDistributionChannels = this.setDistributionChannels;
      result.setLanguages = this.setLanguages;
      result.setName = this.setName;
      result.setSupplyChannels = this.setSupplyChannels;
      return result;
    }

    public Builder addProductSelection(AddStoreProductSelection addProductSelection) {
      this.addProductSelection = addProductSelection;
      return this;
    }

    public Builder addCountry(AddStoreCountry addCountry) {
      this.addCountry = addCountry;
      return this;
    }

    public Builder addDistributionChannel(AddStoreDistributionChannel addDistributionChannel) {
      this.addDistributionChannel = addDistributionChannel;
      return this;
    }

    public Builder addSupplyChannel(AddStoreSupplyChannel addSupplyChannel) {
      this.addSupplyChannel = addSupplyChannel;
      return this;
    }

    public Builder changeProductSelectionActive(
        ChangeStoreProductSelectionActive changeProductSelectionActive) {
      this.changeProductSelectionActive = changeProductSelectionActive;
      return this;
    }

    public Builder removeProductSelection(RemoveStoreProductSelection removeProductSelection) {
      this.removeProductSelection = removeProductSelection;
      return this;
    }

    public Builder removeCountry(RemoveStoreCountry removeCountry) {
      this.removeCountry = removeCountry;
      return this;
    }

    public Builder removeDistributionChannel(
        RemoveStoreDistributionChannel removeDistributionChannel) {
      this.removeDistributionChannel = removeDistributionChannel;
      return this;
    }

    public Builder removeSupplyChannel(RemoveStoreSupplyChannel removeSupplyChannel) {
      this.removeSupplyChannel = removeSupplyChannel;
      return this;
    }

    public Builder setProductSelections(SetStoreProductSelections setProductSelections) {
      this.setProductSelections = setProductSelections;
      return this;
    }

    public Builder setCountries(SetStoreCountries setCountries) {
      this.setCountries = setCountries;
      return this;
    }

    public Builder setCustomField(SetStoreCustomField setCustomField) {
      this.setCustomField = setCustomField;
      return this;
    }

    public Builder setCustomType(SetStoreCustomType setCustomType) {
      this.setCustomType = setCustomType;
      return this;
    }

    public Builder setDistributionChannels(SetStoreDistributionChannels setDistributionChannels) {
      this.setDistributionChannels = setDistributionChannels;
      return this;
    }

    public Builder setLanguages(SetStoreLanguages setLanguages) {
      this.setLanguages = setLanguages;
      return this;
    }

    public Builder setName(SetStoreName setName) {
      this.setName = setName;
      return this;
    }

    public Builder setSupplyChannels(SetStoreSupplyChannels setSupplyChannels) {
      this.setSupplyChannels = setSupplyChannels;
      return this;
    }
  }
}
