package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class StringAttribute implements com.commercetools.graphql.api.types.Attribute {
  private String value;

  private String name;

  public StringAttribute() {
  }

  public StringAttribute(String value, String name) {
    this.value = value;
    this.name = name;
  }

  public String getValue() {
    return value;
  }

  public void setValue(String value) {
    this.value = value;
  }

  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  @Override
  public String toString() {
    return "StringAttribute{value='" + value + "', name='" + name + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    StringAttribute that = (StringAttribute) o;
    return Objects.equals(value, that.value) &&
        Objects.equals(name, that.name);
  }

  @Override
  public int hashCode() {
    return Objects.hash(value, name);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String value;

    private String name;

    public StringAttribute build() {
      StringAttribute result = new StringAttribute();
      result.value = this.value;
      result.name = this.name;
      return result;
    }

    public Builder value(String value) {
      this.value = value;
      return this;
    }

    public Builder name(String name) {
      this.name = name;
      return this;
    }
  }
}
