package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

public class SubscriptionDraft {
  private String key;

  private DestinationInput destination;

  private List<MessageSubscriptionInput> messages;

  private List<ChangeSubscriptionInput> changes;

  private SubscriptionFormatInput format;

  public SubscriptionDraft() {
  }

  public SubscriptionDraft(String key, DestinationInput destination,
      List<MessageSubscriptionInput> messages, List<ChangeSubscriptionInput> changes,
      SubscriptionFormatInput format) {
    this.key = key;
    this.destination = destination;
    this.messages = messages;
    this.changes = changes;
    this.format = format;
  }

  public String getKey() {
    return key;
  }

  public void setKey(String key) {
    this.key = key;
  }

  public DestinationInput getDestination() {
    return destination;
  }

  public void setDestination(DestinationInput destination) {
    this.destination = destination;
  }

  public List<MessageSubscriptionInput> getMessages() {
    return messages;
  }

  public void setMessages(List<MessageSubscriptionInput> messages) {
    this.messages = messages;
  }

  public List<ChangeSubscriptionInput> getChanges() {
    return changes;
  }

  public void setChanges(List<ChangeSubscriptionInput> changes) {
    this.changes = changes;
  }

  public SubscriptionFormatInput getFormat() {
    return format;
  }

  public void setFormat(SubscriptionFormatInput format) {
    this.format = format;
  }

  @Override
  public String toString() {
    return "SubscriptionDraft{key='" + key + "', destination='" + destination + "', messages='" + messages + "', changes='" + changes + "', format='" + format + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SubscriptionDraft that = (SubscriptionDraft) o;
    return Objects.equals(key, that.key) &&
        Objects.equals(destination, that.destination) &&
        Objects.equals(messages, that.messages) &&
        Objects.equals(changes, that.changes) &&
        Objects.equals(format, that.format);
  }

  @Override
  public int hashCode() {
    return Objects.hash(key, destination, messages, changes, format);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String key;

    private DestinationInput destination;

    private List<MessageSubscriptionInput> messages;

    private List<ChangeSubscriptionInput> changes;

    private SubscriptionFormatInput format;

    public SubscriptionDraft build() {
      SubscriptionDraft result = new SubscriptionDraft();
      result.key = this.key;
      result.destination = this.destination;
      result.messages = this.messages;
      result.changes = this.changes;
      result.format = this.format;
      return result;
    }

    public Builder key(String key) {
      this.key = key;
      return this;
    }

    public Builder destination(DestinationInput destination) {
      this.destination = destination;
      return this;
    }

    public Builder messages(List<MessageSubscriptionInput> messages) {
      this.messages = messages;
      return this;
    }

    public Builder changes(List<ChangeSubscriptionInput> changes) {
      this.changes = changes;
      return this;
    }

    public Builder format(SubscriptionFormatInput format) {
      this.format = format;
      return this;
    }
  }
}
