package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

public class SuggestResult {
  private List<SuggestResultEntry> searchKeywords;

  public SuggestResult() {
  }

  public SuggestResult(List<SuggestResultEntry> searchKeywords) {
    this.searchKeywords = searchKeywords;
  }

  public List<SuggestResultEntry> getSearchKeywords() {
    return searchKeywords;
  }

  public void setSearchKeywords(List<SuggestResultEntry> searchKeywords) {
    this.searchKeywords = searchKeywords;
  }

  @Override
  public String toString() {
    return "SuggestResult{searchKeywords='" + searchKeywords + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SuggestResult that = (SuggestResult) o;
    return Objects.equals(searchKeywords, that.searchKeywords);
  }

  @Override
  public int hashCode() {
    return Objects.hash(searchKeywords);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private List<SuggestResultEntry> searchKeywords;

    public SuggestResult build() {
      SuggestResult result = new SuggestResult();
      result.searchKeywords = this.searchKeywords;
      return result;
    }

    public Builder searchKeywords(List<SuggestResultEntry> searchKeywords) {
      this.searchKeywords = searchKeywords;
      return this;
    }
  }
}
