package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

public class SuggestResultEntry {
  private String locale;

  private List<Suggestion> suggestions;

  public SuggestResultEntry() {
  }

  public SuggestResultEntry(String locale, List<Suggestion> suggestions) {
    this.locale = locale;
    this.suggestions = suggestions;
  }

  public String getLocale() {
    return locale;
  }

  public void setLocale(String locale) {
    this.locale = locale;
  }

  public List<Suggestion> getSuggestions() {
    return suggestions;
  }

  public void setSuggestions(List<Suggestion> suggestions) {
    this.suggestions = suggestions;
  }

  @Override
  public String toString() {
    return "SuggestResultEntry{locale='" + locale + "', suggestions='" + suggestions + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SuggestResultEntry that = (SuggestResultEntry) o;
    return Objects.equals(locale, that.locale) &&
        Objects.equals(suggestions, that.suggestions);
  }

  @Override
  public int hashCode() {
    return Objects.hash(locale, suggestions);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String locale;

    private List<Suggestion> suggestions;

    public SuggestResultEntry build() {
      SuggestResultEntry result = new SuggestResultEntry();
      result.locale = this.locale;
      result.suggestions = this.suggestions;
      return result;
    }

    public Builder locale(String locale) {
      this.locale = locale;
      return this;
    }

    public Builder suggestions(List<Suggestion> suggestions) {
      this.suggestions = suggestions;
      return this;
    }
  }
}
