package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.String;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NAME,
    include = JsonTypeInfo.As.PROPERTY,
    property = "__typename"
)
@JsonSubTypes({
    @JsonSubTypes.Type(value = CustomSuggestTokenizer.class, name = "CustomSuggestTokenizer"),
    @JsonSubTypes.Type(value = WhitespaceSuggestTokenizer.class, name = "WhitespaceSuggestTokenizer")
})
public interface SuggestTokenizer {
  String getType();

  void setType(String type);
}
