package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class TaxCategoryAddTaxRate {
  private TaxRateDraft taxRate;

  public TaxCategoryAddTaxRate() {
  }

  public TaxCategoryAddTaxRate(TaxRateDraft taxRate) {
    this.taxRate = taxRate;
  }

  public TaxRateDraft getTaxRate() {
    return taxRate;
  }

  public void setTaxRate(TaxRateDraft taxRate) {
    this.taxRate = taxRate;
  }

  @Override
  public String toString() {
    return "TaxCategoryAddTaxRate{taxRate='" + taxRate + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    TaxCategoryAddTaxRate that = (TaxCategoryAddTaxRate) o;
    return Objects.equals(taxRate, that.taxRate);
  }

  @Override
  public int hashCode() {
    return Objects.hash(taxRate);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private TaxRateDraft taxRate;

    public TaxCategoryAddTaxRate build() {
      TaxCategoryAddTaxRate result = new TaxCategoryAddTaxRate();
      result.taxRate = this.taxRate;
      return result;
    }

    public Builder taxRate(TaxRateDraft taxRate) {
      this.taxRate = taxRate;
      return this;
    }
  }
}
