package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class TaxCategoryLimitsProjection {
  private TaxCategoryLimitWithCurrent total;

  public TaxCategoryLimitsProjection() {
  }

  public TaxCategoryLimitsProjection(TaxCategoryLimitWithCurrent total) {
    this.total = total;
  }

  public TaxCategoryLimitWithCurrent getTotal() {
    return total;
  }

  public void setTotal(TaxCategoryLimitWithCurrent total) {
    this.total = total;
  }

  @Override
  public String toString() {
    return "TaxCategoryLimitsProjection{total='" + total + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    TaxCategoryLimitsProjection that = (TaxCategoryLimitsProjection) o;
    return Objects.equals(total, that.total);
  }

  @Override
  public int hashCode() {
    return Objects.hash(total);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private TaxCategoryLimitWithCurrent total;

    public TaxCategoryLimitsProjection build() {
      TaxCategoryLimitsProjection result = new TaxCategoryLimitsProjection();
      result.total = this.total;
      return result;
    }

    public Builder total(TaxCategoryLimitWithCurrent total) {
      this.total = total;
      return this;
    }
  }
}
