package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class TaxCategoryRemoveTaxRate {
  private String taxRateId;

  private String taxRateKey;

  public TaxCategoryRemoveTaxRate() {
  }

  public TaxCategoryRemoveTaxRate(String taxRateId, String taxRateKey) {
    this.taxRateId = taxRateId;
    this.taxRateKey = taxRateKey;
  }

  public String getTaxRateId() {
    return taxRateId;
  }

  public void setTaxRateId(String taxRateId) {
    this.taxRateId = taxRateId;
  }

  public String getTaxRateKey() {
    return taxRateKey;
  }

  public void setTaxRateKey(String taxRateKey) {
    this.taxRateKey = taxRateKey;
  }

  @Override
  public String toString() {
    return "TaxCategoryRemoveTaxRate{taxRateId='" + taxRateId + "', taxRateKey='" + taxRateKey + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    TaxCategoryRemoveTaxRate that = (TaxCategoryRemoveTaxRate) o;
    return Objects.equals(taxRateId, that.taxRateId) &&
        Objects.equals(taxRateKey, that.taxRateKey);
  }

  @Override
  public int hashCode() {
    return Objects.hash(taxRateId, taxRateKey);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String taxRateId;

    private String taxRateKey;

    public TaxCategoryRemoveTaxRate build() {
      TaxCategoryRemoveTaxRate result = new TaxCategoryRemoveTaxRate();
      result.taxRateId = this.taxRateId;
      result.taxRateKey = this.taxRateKey;
      return result;
    }

    public Builder taxRateId(String taxRateId) {
      this.taxRateId = taxRateId;
      return this;
    }

    public Builder taxRateKey(String taxRateKey) {
      this.taxRateKey = taxRateKey;
      return this;
    }
  }
}
