package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class TaxCategoryReplaceTaxRate {
  private String taxRateId;

  private String taxRateKey;

  private TaxRateDraft taxRate;

  public TaxCategoryReplaceTaxRate() {
  }

  public TaxCategoryReplaceTaxRate(String taxRateId, String taxRateKey, TaxRateDraft taxRate) {
    this.taxRateId = taxRateId;
    this.taxRateKey = taxRateKey;
    this.taxRate = taxRate;
  }

  public String getTaxRateId() {
    return taxRateId;
  }

  public void setTaxRateId(String taxRateId) {
    this.taxRateId = taxRateId;
  }

  public String getTaxRateKey() {
    return taxRateKey;
  }

  public void setTaxRateKey(String taxRateKey) {
    this.taxRateKey = taxRateKey;
  }

  public TaxRateDraft getTaxRate() {
    return taxRate;
  }

  public void setTaxRate(TaxRateDraft taxRate) {
    this.taxRate = taxRate;
  }

  @Override
  public String toString() {
    return "TaxCategoryReplaceTaxRate{taxRateId='" + taxRateId + "', taxRateKey='" + taxRateKey + "', taxRate='" + taxRate + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    TaxCategoryReplaceTaxRate that = (TaxCategoryReplaceTaxRate) o;
    return Objects.equals(taxRateId, that.taxRateId) &&
        Objects.equals(taxRateKey, that.taxRateKey) &&
        Objects.equals(taxRate, that.taxRate);
  }

  @Override
  public int hashCode() {
    return Objects.hash(taxRateId, taxRateKey, taxRate);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String taxRateId;

    private String taxRateKey;

    private TaxRateDraft taxRate;

    public TaxCategoryReplaceTaxRate build() {
      TaxCategoryReplaceTaxRate result = new TaxCategoryReplaceTaxRate();
      result.taxRateId = this.taxRateId;
      result.taxRateKey = this.taxRateKey;
      result.taxRate = this.taxRate;
      return result;
    }

    public Builder taxRateId(String taxRateId) {
      this.taxRateId = taxRateId;
      return this;
    }

    public Builder taxRateKey(String taxRateKey) {
      this.taxRateKey = taxRateKey;
      return this;
    }

    public Builder taxRate(TaxRateDraft taxRate) {
      this.taxRate = taxRate;
      return this;
    }
  }
}
