package com.commercetools.graphql.api.types;

import java.lang.Double;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

/**
 * Represents the portions that sum up to the totalGross field of a TaxedPrice. The portions are calculated
 * from the TaxRates. If a tax rate has SubRates, they are used and can be identified by name. Tax portions
 * from line items that have the same rate and name will be accumulated to the same tax portion.
 */
public class TaxPortion {
  private Double rate;

  private Money amount;

  private String name;

  public TaxPortion() {
  }

  public TaxPortion(Double rate, Money amount, String name) {
    this.rate = rate;
    this.amount = amount;
    this.name = name;
  }

  public Double getRate() {
    return rate;
  }

  public void setRate(Double rate) {
    this.rate = rate;
  }

  public Money getAmount() {
    return amount;
  }

  public void setAmount(Money amount) {
    this.amount = amount;
  }

  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  @Override
  public String toString() {
    return "TaxPortion{rate='" + rate + "', amount='" + amount + "', name='" + name + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    TaxPortion that = (TaxPortion) o;
    return Objects.equals(rate, that.rate) &&
        Objects.equals(amount, that.amount) &&
        Objects.equals(name, that.name);
  }

  @Override
  public int hashCode() {
    return Objects.hash(rate, amount, name);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private Double rate;

    private Money amount;

    private String name;

    public TaxPortion build() {
      TaxPortion result = new TaxPortion();
      result.rate = this.rate;
      result.amount = this.amount;
      result.name = this.name;
      return result;
    }

    public Builder rate(Double rate) {
      this.rate = rate;
      return this;
    }

    public Builder amount(Money amount) {
      this.amount = amount;
      return this;
    }

    public Builder name(String name) {
      this.name = name;
      return this;
    }
  }
}
