package com.commercetools.graphql.api.types;

import java.lang.Double;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class TaxPortionDraft {
  private String name;

  private Double rate;

  private MoneyInput amount;

  public TaxPortionDraft() {
  }

  public TaxPortionDraft(String name, Double rate, MoneyInput amount) {
    this.name = name;
    this.rate = rate;
    this.amount = amount;
  }

  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public Double getRate() {
    return rate;
  }

  public void setRate(Double rate) {
    this.rate = rate;
  }

  public MoneyInput getAmount() {
    return amount;
  }

  public void setAmount(MoneyInput amount) {
    this.amount = amount;
  }

  @Override
  public String toString() {
    return "TaxPortionDraft{name='" + name + "', rate='" + rate + "', amount='" + amount + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    TaxPortionDraft that = (TaxPortionDraft) o;
    return Objects.equals(name, that.name) &&
        Objects.equals(rate, that.rate) &&
        Objects.equals(amount, that.amount);
  }

  @Override
  public int hashCode() {
    return Objects.hash(name, rate, amount);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String name;

    private Double rate;

    private MoneyInput amount;

    public TaxPortionDraft build() {
      TaxPortionDraft result = new TaxPortionDraft();
      result.name = this.name;
      result.rate = this.rate;
      result.amount = this.amount;
      return result;
    }

    public Builder name(String name) {
      this.name = name;
      return this;
    }

    public Builder rate(Double rate) {
      this.rate = rate;
      return this;
    }

    public Builder amount(MoneyInput amount) {
      this.amount = amount;
      return this;
    }
  }
}
