package com.commercetools.graphql.api.types;

import java.lang.Boolean;
import java.lang.Double;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

public class TaxRate {
  private String name;

  private Double amount;

  private Boolean includedInPrice;

  private String country;

  private String state;

  private String id;

  private String key;

  private List<SubRate> subRates;

  public TaxRate() {
  }

  public TaxRate(String name, Double amount, Boolean includedInPrice, String country, String state,
      String id, String key, List<SubRate> subRates) {
    this.name = name;
    this.amount = amount;
    this.includedInPrice = includedInPrice;
    this.country = country;
    this.state = state;
    this.id = id;
    this.key = key;
    this.subRates = subRates;
  }

  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public Double getAmount() {
    return amount;
  }

  public void setAmount(Double amount) {
    this.amount = amount;
  }

  public Boolean getIncludedInPrice() {
    return includedInPrice;
  }

  public void setIncludedInPrice(Boolean includedInPrice) {
    this.includedInPrice = includedInPrice;
  }

  public String getCountry() {
    return country;
  }

  public void setCountry(String country) {
    this.country = country;
  }

  public String getState() {
    return state;
  }

  public void setState(String state) {
    this.state = state;
  }

  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }

  public String getKey() {
    return key;
  }

  public void setKey(String key) {
    this.key = key;
  }

  public List<SubRate> getSubRates() {
    return subRates;
  }

  public void setSubRates(List<SubRate> subRates) {
    this.subRates = subRates;
  }

  @Override
  public String toString() {
    return "TaxRate{name='" + name + "', amount='" + amount + "', includedInPrice='" + includedInPrice + "', country='" + country + "', state='" + state + "', id='" + id + "', key='" + key + "', subRates='" + subRates + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    TaxRate that = (TaxRate) o;
    return Objects.equals(name, that.name) &&
        Objects.equals(amount, that.amount) &&
        Objects.equals(includedInPrice, that.includedInPrice) &&
        Objects.equals(country, that.country) &&
        Objects.equals(state, that.state) &&
        Objects.equals(id, that.id) &&
        Objects.equals(key, that.key) &&
        Objects.equals(subRates, that.subRates);
  }

  @Override
  public int hashCode() {
    return Objects.hash(name, amount, includedInPrice, country, state, id, key, subRates);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String name;

    private Double amount;

    private Boolean includedInPrice;

    private String country;

    private String state;

    private String id;

    private String key;

    private List<SubRate> subRates;

    public TaxRate build() {
      TaxRate result = new TaxRate();
      result.name = this.name;
      result.amount = this.amount;
      result.includedInPrice = this.includedInPrice;
      result.country = this.country;
      result.state = this.state;
      result.id = this.id;
      result.key = this.key;
      result.subRates = this.subRates;
      return result;
    }

    public Builder name(String name) {
      this.name = name;
      return this;
    }

    public Builder amount(Double amount) {
      this.amount = amount;
      return this;
    }

    public Builder includedInPrice(Boolean includedInPrice) {
      this.includedInPrice = includedInPrice;
      return this;
    }

    public Builder country(String country) {
      this.country = country;
      return this;
    }

    public Builder state(String state) {
      this.state = state;
      return this;
    }

    public Builder id(String id) {
      this.id = id;
      return this;
    }

    public Builder key(String key) {
      this.key = key;
      return this;
    }

    public Builder subRates(List<SubRate> subRates) {
      this.subRates = subRates;
      return this;
    }
  }
}
